/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.config;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="goetydelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_ITEMS = BUILDER.comment("A list of blacklisted items that will be hidden from creative tabs and prevent drops").defineListAllowEmpty("blacklistedItems", List.of("goetydelight:roasted_corpse_maggots", "goetydelight:corpse_maggot", "goetydelight:rotten_corpse_maggot_feast", "goetydelight:rotten_corpse_maggot_feast_block"), Config::validateItemName);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static Set<Item> blacklistedItems;
    private static Consumer<Void> blackListUpdateListener;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        blacklistedItems = ((List)BLACKLISTED_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
        if (blackListUpdateListener != null) {
            blackListUpdateListener.accept(null);
        }
    }

    public static void registerBlackListUpdateListener(Consumer<Void> listener) {
        blackListUpdateListener = listener;
    }
}

