/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.v_black_cat.goetydelight.GoetyDelight;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;
import net.v_black_cat.goetydelight.effect.ModEffects;
import org.jetbrains.annotations.Nullable;

public class WardenEffect
extends MobEffect {
    private final Map<UUID, VibrationSystem.Data> activeData = new HashMap<UUID, VibrationSystem.Data>();
    private final Map<UUID, VibrationSystem.User> activeUsers = new HashMap<UUID, VibrationSystem.User>();
    private final Map<UUID, DynamicGameEventListener<VibrationSystem.Listener>> activeListeners = new HashMap<UUID, DynamicGameEventListener<VibrationSystem.Listener>>();
    private final Map<UUID, VibrationTargetData> vibrationTargets = new HashMap<UUID, VibrationTargetData>();

    public WardenEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UUID id = entity.m_20148_();
        this.updateVibrationTargets(entity);
        final VibrationSystem.Data data = this.activeData.computeIfAbsent(id, k -> new VibrationSystem.Data());
        final VibrationSystem.User user = this.activeUsers.computeIfAbsent(id, k -> new EffectVibrationUser(entity));
        DynamicGameEventListener listener = this.activeListeners.computeIfAbsent(id, k -> {
            DynamicGameEventListener newListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener(new VibrationSystem(){

                public VibrationSystem.Data m_280002_() {
                    return data;
                }

                public VibrationSystem.User m_280445_() {
                    return user;
                }
            }));
            newListener.m_223617_(serverLevel);
            GoetyDelight.LOGGER.debug("[WardenEffect] Registered new vibration listener for {}", (Object)entity.m_7755_().getString());
            return newListener;
        });
        VibrationSystem.Ticker.m_280259_((Level)serverLevel, (VibrationSystem.Data)data, (VibrationSystem.User)user);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6386_(LivingEntity entity, AttributeMap map, int amplifier) {
        super.m_6386_(entity, map, amplifier);
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UUID id = entity.m_20148_();
        DynamicGameEventListener<VibrationSystem.Listener> listener = this.activeListeners.remove(id);
        if (listener != null) {
            listener.m_223634_(serverLevel);
        }
        this.activeData.remove(id);
        this.activeUsers.remove(id);
        this.vibrationTargets.remove(id);
        GoetyDelight.LOGGER.debug("[WardenEffect] Removed vibration listener for {}", (Object)entity.m_7755_().getString());
    }

    private void updateVibrationTargets(LivingEntity entity) {
        UUID id = entity.m_20148_();
        VibrationTargetData targetData = this.vibrationTargets.get(id);
        if (targetData != null) {
            --targetData.remainingTicks;
            if (targetData.remainingTicks <= 0) {
                this.vibrationTargets.remove(id);
                GoetyDelight.LOGGER.debug("[WardenEffect] Damage boost effect for {} against {} has ended", (Object)entity.m_7755_().getString(), (Object)(targetData.targetName != null ? targetData.targetName : "Unknown entity"));
            }
        }
    }

    public static boolean hasDamageBoostAgainst(LivingEntity attacker, LivingEntity target) {
        if (attacker == null || target == null) {
            return false;
        }
        if (attacker.m_21023_((MobEffect)ModEffects.WARDEN.get())) {
            if (TimedAbilitySystem.hasAbility(target, "warden_detected")) {
                return true;
            }
            WardenEffect effect = (WardenEffect)Objects.requireNonNull(attacker.m_21124_((MobEffect)ModEffects.WARDEN.get())).m_19544_();
            UUID attackerId = attacker.m_20148_();
            UUID targetId = target.m_20148_();
            VibrationTargetData targetData = effect.vibrationTargets.get(attackerId);
            if (targetData != null && targetData.targetId != null && targetData.targetId.equals(targetId)) {
                return targetData.remainingTicks > 0;
            }
        }
        return false;
    }

    public static float getDamageBoostMultiplier() {
        return 1.5f;
    }

    private static class VibrationTargetData {
        public UUID targetId;
        public String targetName;
        public int remainingTicks;

        public VibrationTargetData(UUID targetId, String targetName, int durationTicks) {
            this.targetId = targetId;
            this.targetName = targetName;
            this.remainingTicks = durationTicks;
        }
    }

    private static class EffectVibrationUser
    implements VibrationSystem.User {
        private static final int LISTENER_RANGE = 16;
        private static final int DAMAGE_BOOST_DURATION = 100;
        private final EntityPositionSource positionSource;
        private final LivingEntity owner;

        public EffectVibrationUser(LivingEntity owner) {
            this.owner = owner;
            this.positionSource = new EntityPositionSource((Entity)owner, owner.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280076_() {
            return true;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context context) {
            return context == null || context.f_223711_() != this.owner;
        }

        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent event, @Nullable Entity source, @Nullable Entity projectile, float distance) {
            String srcName = source != null ? source.m_7755_().getString() : "Environment";
            GoetyDelight.LOGGER.debug("[WardenEffect] {} sensed vibration event from {}", (Object)this.owner.m_7755_().getString(), (Object)srcName);
            if (source instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)source;
                UUID ownerId = this.owner.m_20148_();
                UUID targetId = target.m_20148_();
                if (this.owner.m_21023_((MobEffect)ModEffects.WARDEN.get())) {
                    WardenEffect effect = (WardenEffect)this.owner.m_21124_((MobEffect)ModEffects.WARDEN.get()).m_19544_();
                    VibrationTargetData targetData = new VibrationTargetData(targetId, target.m_7755_().getString(), 100);
                    effect.vibrationTargets.put(ownerId, targetData);
                    TimedAbilitySystem.addAbilityToEntity(target, "warden_detected", 100);
                    GoetyDelight.LOGGER.debug("[WardenEffect] {} gained damage boost against {} for 5 seconds", (Object)this.owner.m_7755_().getString(), (Object)target.m_7755_().getString());
                }
            }
            double dx = (double)pos.m_123341_() + level.f_46441_.m_188500_();
            double dy = (double)pos.m_123342_() + 1.0;
            double dz = (double)pos.m_123343_() + level.f_46441_.m_188500_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
        }

        public boolean m_280215_() {
            return false;
        }

        public int m_280576_(float distance) {
            return Mth.m_14143_((float)distance);
        }

        public boolean m_280612_(GameEvent event, GameEvent.Context context) {
            return true;
        }

        public void m_280022_() {
        }
    }
}

