/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.enchantments;

import com.Polarice3.Goety.utils.SEHelper;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.enchantments.ModEnchantments;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="goetydelight")
public class SoulHealingEnchantment
extends Enchantment {
    public static final EnchantmentCategory CHESTPLATE = EnchantmentCategory.create((String)"CHESTPLATE", item -> item instanceof ArmorItem && ((ArmorItem)item).m_40402_() == EquipmentSlot.CHEST);

    public SoulHealingEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot ... slots) {
        super(rarity, CHESTPLATE, new EquipmentSlot[]{EquipmentSlot.CHEST});
    }

    public int m_6183_(int enchantmentLevel) {
        return 30 + (enchantmentLevel - 1) * 9;
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 30;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return true;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.CHEST;
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return this.m_6081_(stack);
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public boolean m_5975_(@NotNull Enchantment other) {
        return super.m_5975_(other) && !(other instanceof MendingEnchantment) && other.m_44695_((Enchantment)ModEnchantments.SOUL_MENDING.get());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int enchantmentLevel;
        Player player;
        ItemStack chestArmor;
        if (event.phase == TickEvent.Phase.END && event.player.f_19797_ % 10 == 0 && event.side.isServer() && !(chestArmor = (player = event.player).m_6844_(EquipmentSlot.CHEST)).m_41619_() && (enchantmentLevel = chestArmor.getEnchantmentLevel((Enchantment)ModEnchantments.SOUL_HEALING.get())) > 0) {
            SoulHealingEnchantment.healPlayerWithSoulEnergy(player, enchantmentLevel);
        }
    }

    private static void healPlayerWithSoulEnergy(Player player, int enchantmentLevel) {
        if (player.m_21223_() < player.m_21233_()) {
            float maxHealth = player.m_21233_();
            float healAmount = (1.0f + 0.01f * maxHealth) * (float)enchantmentLevel;
            int soulEnergyCost = 5 * enchantmentLevel;
            if (healAmount > 0.5f * maxHealth) {
                healAmount = 0.5f * maxHealth;
            }
            if (SEHelper.getSoulsAmount((Player)player, (int)soulEnergyCost)) {
                player.m_5634_(healAmount);
                SEHelper.soulDiscount((LivingEntity)player);
            }
            if (player.m_21223_() < player.m_21233_() - 0.25f && !player.m_21224_() && player.m_21223_() < healAmount + player.m_21223_()) {
                player.m_21153_(player.m_21223_() + 0.25f);
            }
        }
    }
}

