/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.enchantments;

import com.Polarice3.Goety.utils.SEHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.enchantments.ModEnchantments;

@Mod.EventBusSubscriber(modid="goetydelight")
public class SoulMendingEnchantment
extends Enchantment {
    public SoulMendingEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot ... slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int enchantmentLevel) {
        return 15 + (enchantmentLevel - 1) * 9;
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 15;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return false;
    }

    public boolean m_6594_() {
        return true;
    }

    public boolean m_6592_() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.m_41763_();
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41763_();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.f_19797_ % 4 == 0) {
            Player player = event.player;
            for (ItemStack stack : player.m_20158_()) {
                int enchantmentLevel = stack.getEnchantmentLevel((Enchantment)ModEnchantments.SOUL_MENDING.get());
                if (!stack.m_41793_() || enchantmentLevel <= 0) continue;
                SoulMendingEnchantment.repairItemWithSoulEnergy(player, stack, enchantmentLevel);
            }
        }
    }

    private static void repairItemWithSoulEnergy(Player player, ItemStack stack, int enchantmentLevel) {
        int currentDamage = stack.m_41773_();
        if (currentDamage <= 0) {
            return;
        }
        int repairAmount = enchantmentLevel;
        int actualRepair = Math.min(repairAmount, currentDamage);
        int requiredSouls = enchantmentLevel > 9 ? 0 : (actualRepair < enchantmentLevel ? Math.max(1, 5 - enchantmentLevel / 2) : actualRepair * 5);
        if (requiredSouls <= 0 || SEHelper.getSoulsAmount((Player)player, (int)requiredSouls)) {
            if (requiredSouls > 0) {
                SEHelper.decreaseSouls((Player)player, (int)requiredSouls);
            }
            int newDamage = currentDamage - actualRepair;
            stack.m_41721_(newDamage);
        }
    }
}

