/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.entities;

import com.Polarice3.Goety.common.entities.ai.FloatSwimGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.AbstractWraith;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.block.ModBlocks;
import net.v_black_cat.goetydelight.item.ModItems;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.RichSoilFarmlandBlock;

public class GhostFarmerEntity
extends AbstractWraith
implements Merchant {
    private static final int MAX_GROWTH_STAGE = 7;
    private static final double PLANT_CHANCE = 0.05;
    private static final int SCAN_RADIUS = 15;
    private static final String PLANTED_STEMS_TAG = "PlantedStems";
    private static final Component TRADE_TITLE = Component.m_237115_((String)"entity.goetydelight.ghost_farmer.trade");
    private static final Component NOT_NIGHT_MESSAGE = Component.m_237115_((String)"entity.goetydelight.ghost_farmer.not_night");
    public final AnimationState idleAnimationState = new AnimationState();
    private final Set<BlockPos> plantStemsPos = new HashSet<BlockPos>();
    private final Set<BlockPos> attachedStems = new HashSet<BlockPos>();
    private final Set<BlockPos> plantedPos = new HashSet<BlockPos>();
    private final SimpleContainer inventory = new SimpleContainer(8);
    @Nullable
    protected MerchantOffers offers;
    @Nullable
    private Player tradingPlayer;
    private long lastRestockTime = -1L;
    private boolean hasRestockedToday = false;
    public final AnimationState attackAnimationState = new AnimationState();
    private int attackTick = 0;
    private static final int ATTACK_DURATION = 38;
    private Player attackTarget;
    private int idleAnimationTimeout = 0;
    private int attackAnimationTimeout = 0;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(GhostFarmerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GhostFarmerEntity(EntityType<? extends Summoned> entityType, Level level) {
        super(entityType, level);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        } else {
            this.checkMidnightRestock();
            if (this.isAttacking()) {
                ++this.attackTick;
                if (this.attackTick == 19 && this.attackTarget != null) {
                    this.executePlayer(this.attackTarget);
                }
                if (this.attackTick >= 38) {
                    this.resetAttack();
                }
            }
            if (this.isNightTime() && this.isInTargetStructure()) {
                if (this.f_19797_ % 20 == 0) {
                    this.checkAndRemoveInvalidPlantingSites();
                    this.melonStemWithered();
                    this.acceleratingStemsGrowth();
                }
                if (this.f_19797_ % 100 == 0) {
                    this.scanForSuitablePlantingLocations();
                    this.plantMelonStems();
                }
            }
            if (!(this.isNightTime() || this.plantStemsPos.isEmpty() && this.attachedStems.isEmpty())) {
                this.plantStemsPos.clear();
                this.attachedStems.clear();
                this.plantedPos.clear();
            }
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isAttacking()) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 38;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (this.attackAnimationTimeout > 0) {
            --this.attackAnimationTimeout;
            if (this.attackAnimationTimeout <= 0) {
                this.attackAnimationState.m_216973_();
            }
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void m_6255_(@Nullable MerchantOffers offers) {
        this.offers = offers;
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
    }

    public void m_7713_(ItemStack stack) {
        if (!this.m_9236_().f_46443_) {
            this.m_5496_(this.getTradeUpdatedSound(!stack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xp) {
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public void m_45301_(Player player, Component displayName, int level) {
        MerchantOffers merchantoffers;
        OptionalInt optionalint = player.m_5893_((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new GhostFarmerMerchantMenu(containerId, playerInventory, this), this.getCustomTradeTitle()));
        if (optionalint.isPresent() && !(merchantoffers = this.m_6616_()).isEmpty()) {
            player.m_7662_(optionalint.getAsInt(), merchantoffers, 0, 0, false, false);
        }
    }

    protected Component getCustomTradeTitle() {
        return TRADE_TITLE;
    }

    protected void updateTrades() {
        this.offers.clear();
        this.offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42578_, 1), new ItemStack((ItemLike)com.Polarice3.Goety.common.items.ModItems.ECTOPLASM.get(), 2), new ItemStack((ItemLike)ModItems.ECTOPLASMIC_MELON_SEEDS.get(), 1), 12, 0, 0.0f));
        this.offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)com.Polarice3.Goety.common.items.ModItems.ECTOPLASM.get(), 18), new ItemStack((ItemLike)Items.f_42028_, 1), new ItemStack((ItemLike)((Block)ModBlocks.ECTOPLASMIC_MELON_BLOCK.get()).m_5456_(), 1), 12, 0, 0.0f));
        this.offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)com.Polarice3.Goety.common.items.ModItems.ECTOPLASM.get(), 3), new ItemStack((ItemLike)Items.f_42575_, 1), new ItemStack((ItemLike)ModItems.ECTOPLASMIC_MELON.get(), 1), Integer.MAX_VALUE, 0, 0.0f));
    }

    protected void stopTrading() {
        this.m_7189_(null);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() != Items.f_42601_ && this.m_6084_() && !this.isTrading()) {
            if (!this.m_9236_().f_46443_ && !this.isNightTime()) {
                player.m_5661_(NOT_NIGHT_MESSAGE, true);
                return InteractionResult.m_19078_((boolean)false);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.startTrading(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void startTrading(Player player) {
        this.m_7189_(player);
        this.m_45301_(player, this.m_5446_(), 0);
    }

    public boolean canTradeNow() {
        return this.isNightTime();
    }

    private void melonStemWithered() {
        for (BlockPos stemPos : this.attachedStems) {
            Block blockBelow;
            BlockPos pos;
            Block block = this.m_9236_().m_8055_(stemPos).m_60734_();
            if (block instanceof AttachedStemBlock) {
                pos = stemPos.m_7495_();
                blockBelow = this.m_9236_().m_8055_(pos).m_60734_();
                if (!(blockBelow instanceof RichSoilFarmlandBlock)) continue;
                this.m_9236_().m_46597_(stemPos, (BlockState)((Block)ModBlocks.ECTOPLASMIC_MELON_STEM.get()).m_49966_().m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(7)));
                continue;
            }
            if (!(block instanceof StemBlock)) continue;
            pos = stemPos.m_7495_();
            blockBelow = this.m_9236_().m_8055_(pos).m_60734_();
            if (!(blockBelow instanceof RichSoilFarmlandBlock)) continue;
            int currentAge = (Integer)this.m_9236_().m_8055_(stemPos).m_61143_((Property)StemBlock.f_57013_);
            if (currentAge > 0) {
                this.m_9236_().m_46597_(stemPos, (BlockState)this.m_9236_().m_8055_(stemPos).m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(currentAge - 1)));
                continue;
            }
            this.m_9236_().m_7471_(stemPos, false);
        }
    }

    private void checkAndRemoveInvalidPlantingSites() {
        this.plantStemsPos.removeIf(pos -> {
            Block block = this.m_9236_().m_8055_(pos).m_60734_();
            if (!(block instanceof StemBlock)) {
                return true;
            }
            return this.attachedStems.contains(pos);
        });
    }

    private void acceleratingStemsGrowth() {
        for (BlockPos stemPos : this.plantStemsPos) {
            Block block;
            if (this.attachedStems.contains(stemPos) || !((block = this.m_9236_().m_8055_(stemPos).m_60734_()) instanceof StemBlock)) continue;
            int age = (Integer)this.m_9236_().m_8055_(stemPos).m_61143_((Property)StemBlock.f_57013_);
            if (age < 7) {
                this.m_9236_().m_46597_(stemPos, (BlockState)this.m_9236_().m_8055_(stemPos).m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age + 1)));
            }
            if (age >= 7) {
                for (int i = 0; i < 10; ++i) {
                    Block stemBlock = this.m_9236_().m_8055_(stemPos).m_60734_();
                    stemBlock.m_213898_(this.m_9236_().m_8055_(stemPos), (ServerLevel)this.m_9236_(), stemPos, this.m_9236_().f_46441_);
                }
            }
            if (!(this.m_9236_().m_8055_(stemPos).m_60734_() instanceof AttachedStemBlock)) continue;
            this.attachedStems.add(stemPos);
        }
    }

    private void plantMelonStems() {
        for (BlockPos stemPos : this.plantStemsPos) {
            Block block;
            if (this.attachedStems.contains(stemPos) || (block = this.m_9236_().m_8055_(stemPos).m_60734_()) instanceof StemBlock || this.plantedPos.contains(stemPos) || !(this.f_19796_.m_188500_() < 0.05)) continue;
            this.m_9236_().m_46597_(stemPos, ((Block)ModBlocks.ECTOPLASMIC_MELON_STEM.get()).m_49966_());
            this.plantedPos.add(stemPos);
        }
    }

    private void scanForSuitablePlantingLocations() {
        int scanRadius = 15;
        BlockPos currentPos = this.m_20183_();
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                for (int y = -2; y <= 2; ++y) {
                    BlockPos pos = currentPos.m_7918_(x, y, z);
                    if (this.attachedStems.contains(pos)) continue;
                    BlockPos posAbove = pos.m_7494_();
                    if (!(this.m_9236_().m_8055_(pos).m_60734_() instanceof RichSoilFarmlandBlock) || !(this.m_9236_().m_8055_(posAbove).m_60734_() instanceof AirBlock)) continue;
                    this.plantStemsPos.add(posAbove);
                }
            }
        }
    }

    private void checkMidnightRestock() {
        long timeOfDay;
        long currentTime = this.m_9236_().m_46468_();
        long currentDay = currentTime / 24000L;
        if (this.lastRestockTime / 24000L < currentDay) {
            this.hasRestockedToday = false;
        }
        if ((timeOfDay = currentTime % 24000L) >= 0L && timeOfDay < 1000L && !this.hasRestockedToday) {
            this.restockTrades();
            this.hasRestockedToday = true;
            this.lastRestockTime = currentTime;
        }
    }

    private void restockTrades() {
        if (this.offers != null) {
            for (MerchantOffer offer : this.offers) {
                offer.m_45372_();
            }
        }
    }

    private boolean isNightTime() {
        long timeOfDay = this.m_9236_().m_46468_() % 24000L;
        return timeOfDay >= 13000L && timeOfDay < 24000L;
    }

    private boolean isInTargetStructure() {
        BlockPos currentPos = this.m_20183_();
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        ResourceKey structure = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("goetydelight", "ectoplasmic_melon_field"));
        StructureStart structureStart = serverLevel.m_215010_().m_220488_(currentPos, structure);
        return structureStart != null && structureStart.m_73603_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatSwimGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new AttackPlayerGoal());
        this.f_21345_.m_25352_(3, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new AbstractWraith.WraithLookGoal((AbstractWraith)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractWraith.WraithLookGoal((AbstractWraith)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractWraith.WraithLookRandomlyGoal((AbstractWraith)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Nullable
    public UUID m_21805_() {
        return null;
    }

    private void startAttack(Player player) {
        this.teleportToPlayerFront(player);
        this.setAttacking(true);
        this.attackTick = 0;
        this.attackTarget = player;
        this.attackAnimationState.m_216977_(this.f_19797_);
        this.m_21573_().m_26573_();
    }

    private void resetAttack() {
        this.setAttacking(false);
        this.attackTick = 0;
        this.attackTarget = null;
        this.attackAnimationState.m_216973_();
    }

    private void executePlayer(Player player) {
        if (!player.m_6084_()) {
            return;
        }
        this.dealMagicDamageToPlayer(player);
        this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123789_);
        if (player instanceof ServerPlayer) {
            player.m_213846_((Component)Component.m_237115_((String)"entity.goetydelight.ghost_farmer.execute_message"));
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.stopTrading();
    }

    @Nullable
    public Entity m_5489_(ServerLevel server) {
        this.stopTrading();
        return super.m_5489_(server);
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particleOption, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    protected SoundEvent getTradeUpdatedSound(boolean success) {
        return success ? SoundEvents.f_12509_ : SoundEvents.f_12507_;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"entity.goetydelight.ghost_farmer");
    }

    public void onEctoplasmicMelonBreak(Player player) {
        this.markPlayerAsSuspicious(player);
        if (this.m_20280_((Entity)player) < 16.0) {
            this.startAttack(player);
        }
    }

    private void markPlayerAsSuspicious(Player player) {
    }

    private boolean hasStolenMelon(Player player) {
        return false;
    }

    private boolean isSuspicious(Player player) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    private void teleportToPlayerFront(Player player) {
        double distance = 2.0;
        double yaw = Math.toRadians(player.m_6080_());
        double x = player.m_20185_() - Math.sin(yaw) * distance;
        double y = player.m_20186_();
        double z = player.m_20189_() + Math.cos(yaw) * distance;
        double dx = player.m_20185_() - (x += (this.f_19796_.m_188500_() - 0.5) * 0.5);
        double dz = player.m_20189_() - (z += (this.f_19796_.m_188500_() - 0.5) * 0.5);
        float yawToPlayer = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        this.m_7678_(x, y, z, yawToPlayer, this.m_146909_());
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.1, 0.0);
    }

    private void dealMagicDamageToPlayer(Player player) {
        float damage = player.m_21233_();
        DamageSource magicDamage = new DamageSource(this.m_269291_().m_269425_().m_269150_(), (Entity)this);
        player.m_213846_((Component)Component.m_237115_((String)"entity.goetydelight.ghost_farmer.attack_message"));
        player.m_6469_(magicDamage, damage);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED || reason == Entity.RemovalReason.KILLED && this.tradingPlayer != null) {
            this.stopTrading();
        }
        super.m_142467_(reason);
    }

    class AttackPlayerGoal
    extends Goal {
        private Player targetPlayer;
        private int cooldown = 0;

        public AttackPlayerGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            if (!GhostFarmerEntity.this.isNightTime() || !GhostFarmerEntity.this.isInTargetStructure()) {
                return false;
            }
            this.targetPlayer = this.findAttackTarget();
            return this.targetPlayer != null && !GhostFarmerEntity.this.isAttacking();
        }

        public boolean m_8045_() {
            return GhostFarmerEntity.this.isAttacking() || this.targetPlayer != null && this.targetPlayer.m_6084_() && GhostFarmerEntity.this.m_20280_((Entity)this.targetPlayer) < 256.0;
        }

        public void m_8056_() {
            if (this.targetPlayer != null) {
                GhostFarmerEntity.this.startAttack(this.targetPlayer);
                this.cooldown = 100;
                GhostFarmerEntity.this.setAttacking(true);
            }
        }

        public void m_8041_() {
            GhostFarmerEntity.this.resetAttack();
            this.targetPlayer = null;
        }

        public void m_8037_() {
            if (this.targetPlayer != null && !GhostFarmerEntity.this.isAttacking()) {
                GhostFarmerEntity.this.m_21563_().m_24960_((Entity)this.targetPlayer, 30.0f, 30.0f);
                if (GhostFarmerEntity.this.m_20280_((Entity)this.targetPlayer) < 16.0) {
                    GhostFarmerEntity.this.startAttack(this.targetPlayer);
                }
            }
        }

        private Player findAttackTarget() {
            AABB searchArea = new AABB(GhostFarmerEntity.this.m_20183_()).m_82400_(16.0);
            List players = GhostFarmerEntity.this.m_9236_().m_45976_(Player.class, searchArea);
            for (Player player : players) {
                if (!GhostFarmerEntity.this.hasStolenMelon(player) && !GhostFarmerEntity.this.isSuspicious(player)) continue;
                return player;
            }
            return null;
        }
    }

    public static class GhostFarmerMerchantMenu
    extends MerchantMenu {
        public GhostFarmerMerchantMenu(int containerId, Inventory playerInventory, Merchant merchant) {
            super(containerId, playerInventory, merchant);
        }
    }

    @Mod.EventBusSubscriber(modid="goetydelight")
    public static class EventHandler {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            if (event.getState().m_60734_() == ModBlocks.ECTOPLASMIC_MELON_BLOCK.get()) {
                Player player = event.getPlayer();
                Level level = player.m_9236_();
                BlockPos breakPos = event.getPos();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ResourceKey structure = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("goetydelight", "ectoplasmic_melon_field"));
                    StructureStart structureStart = serverLevel.m_215010_().m_220488_(breakPos, structure);
                    if (structureStart == null || !structureStart.m_73603_()) {
                        return;
                    }
                }
                AABB searchArea = new AABB(event.getPos()).m_82400_(16.0);
                List ghostFarmers = level.m_45976_(GhostFarmerEntity.class, searchArea);
                for (GhostFarmerEntity ghostFarmer : ghostFarmers) {
                    ghostFarmer.onEctoplasmicMelonBreak(player);
                }
            }
        }
    }
}

