/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.entities;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.projectiles.Hellfire;
import com.Polarice3.Goety.utils.MobUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OwnedHellfire
extends Hellfire {
    public OwnedHellfire(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    public OwnedHellfire(Level world, double pPosX, double pPosY, double pPosZ, @Nullable LivingEntity owner) {
        super(world, pPosX, pPosY, pPosZ, owner);
    }

    public OwnedHellfire(Level world, BlockPos blockPos, @Nullable LivingEntity owner) {
        super(world, blockPos, owner);
    }

    public OwnedHellfire(Level world, Vec3 vector3d, @Nullable LivingEntity owner) {
        super(world, vector3d, owner);
    }

    public void dealDamageTo(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        if (this.shouldBeImmune(target, owner)) {
            return;
        }
        super.dealDamageTo(target);
    }

    private boolean shouldBeImmune(LivingEntity target, LivingEntity owner) {
        if (target == owner) {
            return true;
        }
        if (target instanceof IOwned) {
            IOwned ownedOwner;
            IOwned ownedTarget = (IOwned)target;
            LivingEntity targetOwner = ownedTarget.getTrueOwner();
            if (targetOwner == owner) {
                return true;
            }
            if (targetOwner instanceof IOwned && (ownedOwner = (IOwned)targetOwner).getTrueOwner() == owner) {
                return true;
            }
        }
        return MobUtil.areAllies((Entity)owner, (Entity)target);
    }
}

