/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goetydelight")
public class DarkBrushItem
extends BrushItem {
    private int ACCELERATION_FACTOR = 10;
    private static final String ACCUMULATED_OFFSET_TAG = "AccumulatedOffset";
    private static final double MAX_BRUSH_DISTANCE = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    public DarkBrushItem(Item.Properties pProperties, int acceleration_factor) {
        super(pProperties);
        this.ACCELERATION_FACTOR = acceleration_factor;
    }

    private HitResult m_280200_(LivingEntity entity) {
        return ProjectileUtil.m_278180_((Entity)entity, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)MAX_BRUSH_DISTANCE);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration >= 0 && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HitResult hitresult = this.m_280200_(livingEntity);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.m_8105_(stack) - remainingUseDuration + 1;
                    boolean bl = flag = i % 5 / this.ACCELERATION_FACTOR == 0;
                    if (flag) {
                        BlockEntity blockentity;
                        SoundEvent soundevent;
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = level.m_8055_(blockpos);
                        HumanoidArm humanoidarm = livingEntity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                        this.m_278154_(level, blockhitresult, blockstate, livingEntity.m_20252_(0.0f), humanoidarm);
                        Block block = blockstate.m_60734_();
                        if (block instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)block;
                            soundevent = brushableblock.m_276856_();
                        } else {
                            soundevent = SoundEvents.f_276624_;
                        }
                        level.m_247517_(player, blockpos, soundevent, SoundSource.BLOCKS);
                        if (!level.m_5776_() && (blockentity = level.m_7702_(blockpos)) instanceof BrushableBlockEntity) {
                            BrushableBlockEntity brushableblockentity = (BrushableBlockEntity)blockentity;
                            CompoundTag tag = stack.m_41784_();
                            int accumulatedOffset = tag.m_128451_(ACCUMULATED_OFFSET_TAG);
                            boolean flag1 = false;
                            long baseTime = level.m_46467_();
                            for (int j = 0; j < this.ACCELERATION_FACTOR; ++j) {
                                long fakeTime = baseTime + (long)accumulatedOffset + (long)j;
                                boolean result = brushableblockentity.m_276923_(fakeTime, player, blockhitresult.m_82434_());
                                if (!result) continue;
                                flag1 = true;
                                break;
                            }
                            tag.m_128405_(ACCUMULATED_OFFSET_TAG, accumulatedOffset += this.ACCELERATION_FACTOR);
                            stack.m_41751_(tag);
                            if (flag1) {
                                EquipmentSlot equipmentslot = stack.equals(player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                                stack.m_41622_(1, livingEntity, p_279044_ -> p_279044_.m_21166_(equipmentslot));
                                tag.m_128473_(ACCUMULATED_OFFSET_TAG);
                            }
                        }
                    }
                    return;
                }
            }
            livingEntity.m_21253_();
        } else {
            livingEntity.m_21253_();
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(ACCUMULATED_OFFSET_TAG);
        }
        super.m_5551_(stack, level, livingEntity, timeCharged);
    }
}

