/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.config.Config;

public class ItemBlackList {
    private static final Set<String> BLACK_LIST_SET = new HashSet<String>();

    public static void updateBlackListFromConfig() {
        BLACK_LIST_SET.clear();
        if (Config.blacklistedItems != null) {
            Config.blacklistedItems.stream().map(item -> BuiltInRegistries.f_257033_.m_7981_(item).toString()).forEach(BLACK_LIST_SET::add);
        }
    }

    public static Set<String> getBlackList() {
        return BLACK_LIST_SET;
    }

    public static boolean isBlackListed(String itemName) {
        return BLACK_LIST_SET.contains(itemName);
    }

    public static boolean isBlackListed(Item item) {
        String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
        return ItemBlackList.isBlackListed(itemName);
    }

    public static void addToBlackList(String itemName) {
        BLACK_LIST_SET.add(itemName);
    }

    public static void removeFromBlackList(String itemName) {
        BLACK_LIST_SET.remove(itemName);
    }

    public static boolean isIconBlackListed(String iconString) {
        String itemId;
        String[] parts;
        if (iconString == null || iconString.isEmpty()) {
            return false;
        }
        if (BLACK_LIST_SET.contains(iconString)) {
            return true;
        }
        return iconString.contains(":") && (parts = iconString.split(":")).length >= 2 && BLACK_LIST_SET.contains(itemId = parts[0] + ":" + parts[1]);
    }

    static {
        Config.registerBlackListUpdateListener(v -> ItemBlackList.updateBlackListFromConfig());
        ItemBlackList.updateBlackListFromConfig();
    }

    @Mod.EventBusSubscriber(modid="goetydelight", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CreativeTabHandler {
        @SubscribeEvent
        public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
            CreativeModeTab tab = event.getTab();
            if (tab == null) {
                return;
            }
            MutableHashedLinkedMap entries = event.getEntries();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Item item;
                Map.Entry entry = (Map.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                if (stack.m_41619_() || !ItemBlackList.isBlackListed(item = stack.m_41720_())) continue;
                iterator.remove();
            }
        }
    }

    @Mod.EventBusSubscriber(modid="goetydelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ItemDropHandler {
        @SubscribeEvent
        public static void onLivingDrops(LivingDropsEvent event) {
            Collection drops = event.getDrops();
            if (drops.isEmpty()) {
                return;
            }
            Iterator iterator = drops.iterator();
            while (iterator.hasNext()) {
                ItemEntity itemEntity = (ItemEntity)iterator.next();
                ItemStack itemStack = itemEntity.m_32055_();
                if (!ItemBlackList.isBlackListed(itemStack.m_41720_())) continue;
                iterator.remove();
            }
        }
    }
}

