/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.v_black_cat.goetydelight.util.ParticlesUtil;

public class BoatStuffedRoastedWardenItem
extends Item {
    public static final String SERVINGS_TAG = "Servings";

    public BoatStuffedRoastedWardenItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return super.canContinueUsing(oldStack, newStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack resultStack;
        int servings;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ParticlesUtil.spawnItemParticles(stack, 20, entity);
            player.m_5496_(this.m_6061_(), 0.5f, 1.0f);
        }
        if ((servings = BoatStuffedRoastedWardenItem.getServings(resultStack = stack.m_41777_())) > 1) {
            super.m_5922_(stack, level, entity);
            BoatStuffedRoastedWardenItem.setServings(resultStack, servings - 1);
            return resultStack;
        }
        return super.m_5922_(stack, level, entity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!player.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (BoatStuffedRoastedWardenItem.getServings(stack) <= 0) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseTicks) {
        super.m_5929_(level, entity, stack, remainingUseTicks);
        int totalUseTime = this.m_8105_(stack);
        int usedTicks = totalUseTime - remainingUseTicks;
        if (usedTicks % 5 == 0) {
            ParticlesUtil.spawnItemParticles(stack, 20, entity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                float pitch = 1.0f + (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f;
                player.m_5496_(this.m_6061_(), 0.5f, pitch);
            }
        }
    }

    public static int getServings(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(SERVINGS_TAG);
        if (tag != null && tag.m_128441_("Count")) {
            return tag.m_128451_("Count");
        }
        return 4;
    }

    public static void setServings(ItemStack stack, int servings) {
        if (servings <= 0) {
            stack.m_41749_(SERVINGS_TAG);
            return;
        }
        CompoundTag tag = stack.m_41698_(SERVINGS_TAG);
        tag.m_128405_("Count", servings);
    }

    public boolean m_142522_(ItemStack stack) {
        return BoatStuffedRoastedWardenItem.getServings(stack) < 4;
    }

    public int m_142158_(ItemStack stack) {
        int servings = BoatStuffedRoastedWardenItem.getServings(stack);
        return Math.round((float)servings / 4.0f * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 65280;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new BoatStuffedRoastedWardenClient());
    }

    public static class BoatStuffedRoastedWardenClient
    implements IClientItemExtensions {
        private static final HumanoidModel.ArmPose HOLDING_POSE = HumanoidModel.ArmPose.create((String)"GOETYDELIGHT_HOLD", (boolean)false, (model, entity, arm) -> {
            model.f_102811_.f_104203_ = -1.5707964f;
            model.f_102811_.f_104204_ = 0.0f;
            model.f_102811_.f_104205_ = 0.17453292f;
            model.f_102812_.f_104203_ = -1.5707964f;
            model.f_102812_.f_104204_ = 0.0f;
            model.f_102812_.f_104205_ = -0.17453292f;
        });
        private static final HumanoidModel.ArmPose USING_POSE = HumanoidModel.ArmPose.create((String)"GOETYDELIGHT_USE", (boolean)false, (model, entity, arm) -> {
            float useProgress = 0.0f;
            if (entity.m_21212_() > 0) {
                useProgress = 1.0f - (float)entity.m_21212_() / (float)entity.m_21211_().m_41779_();
            }
            float rotateEffect = Mth.m_14031_((float)(useProgress * 50.0f));
            model.f_102811_.f_104203_ = (float)Math.PI / 180 * (-90.0f + rotateEffect * 15.0f);
            model.f_102811_.f_104205_ = (float)Math.PI / 180 * (10.0f + rotateEffect * 10.0f);
            model.f_102812_.f_104203_ = (float)Math.PI / 180 * (-90.0f + rotateEffect * 15.0f);
            model.f_102812_.f_104205_ = (float)Math.PI / 180 * (-10.0f - rotateEffect * 10.0f);
        });

        public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            ItemStack mainHandItem = entityLiving.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandItem = entityLiving.m_21120_(InteractionHand.OFF_HAND);
            boolean isHoldingInMainHand = mainHandItem.m_41720_() instanceof BoatStuffedRoastedWardenItem;
            boolean isHoldingInOffHand = offHandItem.m_41720_() instanceof BoatStuffedRoastedWardenItem;
            boolean isUsing = entityLiving.m_21211_().m_41720_() instanceof BoatStuffedRoastedWardenItem;
            if (isUsing) {
                return USING_POSE;
            }
            if (isHoldingInMainHand || isHoldingInOffHand) {
                return HOLDING_POSE;
            }
            return HumanoidModel.ArmPose.EMPTY;
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            if (itemInHand.m_41720_() instanceof BoatStuffedRoastedWardenItem) {
                int i;
                int n = i = arm == HumanoidArm.RIGHT ? 1 : -1;
                if (player.m_6117_() && player.m_21211_() == itemInHand) {
                    float useProgress = ((float)player.m_21212_() - partialTick) / (float)itemInHand.m_41779_();
                    float bounceEffect = Mth.m_14031_((float)(useProgress * 20.0f)) * 0.1f;
                    float forwardMove = useProgress * 0.5f + bounceEffect;
                    float upMove = useProgress * 0.3f + Mth.m_14089_((float)(useProgress * 50.0f)) * 0.05f;
                    float rotateEffect = Mth.m_14031_((float)(useProgress * 50.0f)) * 5.0f;
                    poseStack.m_252880_((float)i * 1.0f, -0.9f, -0.72f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f + rotateEffect));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 0.0f + rotateEffect));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * 0.0f));
                    float scale = 1.0f + useProgress * 0.8f;
                    poseStack.m_85841_(1.8f, 1.8f, 1.8f);
                } else {
                    poseStack.m_252880_((float)i * 1.0f, -0.9f, -0.72f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 0.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * 0.0f));
                    poseStack.m_85841_(1.8f, 1.8f, 1.8f);
                }
                return true;
            }
            return false;
        }
    }
}

