/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.item.ModItems;

public class CherryBlossomCakeItem
extends Item {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("15f2e8d8-2ff0-4915-8039-a6807c993b51");
    private static final String ATTACK_DAMAGE_NAME = "Cherry Blossom Cake Attack Boost";

    public CherryBlossomCakeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        if (!level.f_46443_) {
            this.removeAttackDamageBoost(entity);
            AttributeInstance luckAttribute = entity.m_21051_(Attributes.f_22286_);
            double luckValue = luckAttribute != null ? luckAttribute.m_22135_() : 0.0;
            double attackBoost = luckValue * 0.5;
            this.addAttackDamageBoost(entity, attackBoost);
        }
        return resultStack;
    }

    private void addAttackDamageBoost(LivingEntity entity, double boostAmount) {
        AttributeInstance attackDamage = entity.m_21051_(Attributes.f_22281_);
        if (attackDamage != null && boostAmount > 0.0) {
            AttributeModifier modifier = new AttributeModifier(ATTACK_DAMAGE_UUID, ATTACK_DAMAGE_NAME, boostAmount, AttributeModifier.Operation.ADDITION);
            attackDamage.m_22118_(modifier);
        }
    }

    private void removeAttackDamageBoost(LivingEntity entity) {
        AttributeInstance attackDamage = entity.m_21051_(Attributes.f_22281_);
        if (attackDamage != null && attackDamage.m_22111_(ATTACK_DAMAGE_UUID) != null) {
            attackDamage.m_22120_(ATTACK_DAMAGE_UUID);
        }
    }

    @Mod.EventBusSubscriber
    public static class CherryBlossomCakeEventHandler {
        @SubscribeEvent
        public static void onPlayerAttack(LivingHurtEvent event) {
            LivingEntity attacker;
            AttributeInstance attackDamage;
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && (attackDamage = (attacker = (LivingEntity)entity).m_21051_(Attributes.f_22281_)) != null && attackDamage.m_22111_(ATTACK_DAMAGE_UUID) != null) {
                attackDamage.m_22120_(ATTACK_DAMAGE_UUID);
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Entity entity;
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            Level level = player.m_9236_();
            if (stack.m_41720_() == Items.f_271209_ && (entity = event.getTarget()) instanceof Fox) {
                Fox fox = (Fox)entity;
                if (!level.m_5776_()) {
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    ItemStack cherryBlossomCake = new ItemStack((ItemLike)ModItems.CHERRY_BLOSSOM_CAKE.get());
                    fox.m_19983_(cherryBlossomCake);
                    for (int i = 0; i < 7; ++i) {
                        double d0 = level.f_46441_.m_188583_() * 0.02;
                        double d1 = level.f_46441_.m_188583_() * 0.02;
                        double d2 = level.f_46441_.m_188583_() * 0.02;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, fox.m_20185_() + (double)(level.f_46441_.m_188501_() * fox.m_20205_() * 2.0f) - (double)fox.m_20205_(), fox.m_20186_() + 0.5 + (double)(level.f_46441_.m_188501_() * fox.m_20206_()), fox.m_20189_() + (double)(level.f_46441_.m_188501_() * fox.m_20205_() * 2.0f) - (double)fox.m_20205_(), d0, d1, d2);
                    }
                    level.m_6263_(null, fox.m_20185_(), fox.m_20186_(), fox.m_20189_(), SoundEvents.f_11947_, fox.m_5720_(), 1.0f, 1.0f);
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                event.setCanceled(true);
            }
        }
    }
}

