/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.utils.LichdomHelper;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;

public class LichsChaosStewItem
extends Item {
    private static final int MAX_BOOST_COUNT = 5;
    private static final double BOOST_PERCENTAGE = 0.2;
    private static final String STEW_BOOST_COUNT_TAG = "LichStewBoostCount";
    private static final String MINION_BOOST_APPLIED_TAG = "LichStewBoostApplied";
    private static final int FIRE_RESISTANCE_DURATION = -1;
    private static final UUID ATTACK_DAMAGE_BOOST_UUID = UUID.fromString("a90ad9a8-3776-44d1-b6c8-a464269f4bf5");
    private static final UUID MAX_HEALTH_BOOST_UUID = UUID.fromString("2d43842e-d85a-4590-8b6f-daafe15bcbcc");
    private static final UUID ARMOR_BOOST_UUID = UUID.fromString("f1a869ea-d50f-454b-847b-5b4779873078");
    private static final UUID MOVEMENT_SPEED_BOOST_UUID = UUID.fromString("dc658e47-9850-4675-b940-f1caa5501dc5");

    public LichsChaosStewItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (LichdomHelper.isLich((Player)player)) {
            return super.m_7203_(level, player, usedHand);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(usedHand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (LichdomHelper.isLich((Entity)livingEntity)) {
            ItemStack result = super.m_5922_(stack, level, livingEntity);
            if (!level.f_46443_ && livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.increaseStewBoostCount(player);
                this.applyMinionBoosts(player, LichsChaosStewItem.getStewBoostCount(player));
                TimedAbilitySystem.addAbilityToEntity((LivingEntity)player, "permanent_fire_resistance", -1);
                TimedAbilitySystem.addAbilityToEntity((LivingEntity)player, "permanent_save_effects", -1);
            }
            return result;
        }
        return stack;
    }

    public static int getStewBoostCount(Player player) {
        return player.getPersistentData().m_128451_(STEW_BOOST_COUNT_TAG);
    }

    private void increaseStewBoostCount(Player player) {
        int currentCount = LichsChaosStewItem.getStewBoostCount(player);
        if (currentCount < 5) {
            player.getPersistentData().m_128405_(STEW_BOOST_COUNT_TAG, currentCount + 1);
        }
    }

    private void applyMinionBoosts(Player player, int boostCount) {
        if (boostCount <= 0) {
            return;
        }
        for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(64.0))) {
            if (!this.isPlayerMinion(entity, player)) continue;
            LichsChaosStewItem.applyMinionBoost(entity, boostCount);
        }
    }

    private boolean isPlayerMinion(LivingEntity entity, Player player) {
        if (entity instanceof IOwned) {
            IOwned ownedEntity = (IOwned)entity;
            LivingEntity owner = ownedEntity.getTrueOwner();
            return owner == player;
        }
        return false;
    }

    public static void applyMinionBoost(LivingEntity minion, int boostCount) {
        AttributeInstance movementSpeed;
        AttributeInstance armor;
        AttributeInstance maxHealth;
        if (minion.m_9236_().f_46443_) {
            return;
        }
        LichsChaosStewItem.removeMinionBoost(minion);
        double boostMultiplier = 0.2 * (double)boostCount;
        AttributeInstance attackDamage = minion.m_21051_(Attributes.f_22281_);
        if (attackDamage != null) {
            double baseValue = attackDamage.m_22115_();
            double boostValue = baseValue * boostMultiplier;
            attackDamage.m_22125_(new AttributeModifier(ATTACK_DAMAGE_BOOST_UUID, "Lich Stew Attack Boost", boostValue, AttributeModifier.Operation.ADDITION));
        }
        if ((maxHealth = minion.m_21051_(Attributes.f_22276_)) != null) {
            double baseValue = maxHealth.m_22115_();
            double boostValue = baseValue * boostMultiplier;
            maxHealth.m_22125_(new AttributeModifier(MAX_HEALTH_BOOST_UUID, "Lich Stew Health Boost", boostValue, AttributeModifier.Operation.ADDITION));
            minion.m_21153_(minion.m_21223_() + (float)boostValue);
        }
        if ((armor = minion.m_21051_(Attributes.f_22284_)) != null) {
            double baseValue = armor.m_22115_();
            double boostValue = baseValue * boostMultiplier;
            armor.m_22125_(new AttributeModifier(ARMOR_BOOST_UUID, "Lich Stew Armor Boost", boostValue, AttributeModifier.Operation.ADDITION));
        }
        if ((movementSpeed = minion.m_21051_(Attributes.f_22279_)) != null) {
            double baseValue = movementSpeed.m_22115_();
            double boostValue = baseValue * boostMultiplier;
            movementSpeed.m_22125_(new AttributeModifier(MOVEMENT_SPEED_BOOST_UUID, "Lich Stew Speed Boost", boostValue, AttributeModifier.Operation.ADDITION));
        }
        minion.getPersistentData().m_128405_(MINION_BOOST_APPLIED_TAG, boostCount);
    }

    public static void removeMinionBoost(LivingEntity minion) {
        AttributeInstance movementSpeed;
        AttributeInstance armor;
        AttributeInstance maxHealth;
        AttributeInstance attackDamage = minion.m_21051_(Attributes.f_22281_);
        if (attackDamage != null) {
            attackDamage.m_22120_(ATTACK_DAMAGE_BOOST_UUID);
        }
        if ((maxHealth = minion.m_21051_(Attributes.f_22276_)) != null) {
            maxHealth.m_22120_(MAX_HEALTH_BOOST_UUID);
        }
        if ((armor = minion.m_21051_(Attributes.f_22284_)) != null) {
            armor.m_22120_(ARMOR_BOOST_UUID);
        }
        if ((movementSpeed = minion.m_21051_(Attributes.f_22279_)) != null) {
            movementSpeed.m_22120_(MOVEMENT_SPEED_BOOST_UUID);
        }
    }

    @Mod.EventBusSubscriber
    public static class MinionBoostHandler {
        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            int boostCount;
            Player player;
            IOwned ownedEntity;
            LivingEntity owner;
            LivingEntity entity;
            Entity entity2;
            if (!event.getLevel().m_5776_() && (entity2 = event.getEntity()) instanceof LivingEntity && (entity = (LivingEntity)entity2) instanceof IOwned && (owner = (ownedEntity = (IOwned)entity).getTrueOwner()) instanceof Player && LichdomHelper.isLich((Player)(player = (Player)owner)) && (boostCount = LichsChaosStewItem.getStewBoostCount(player)) > 0) {
                LichsChaosStewItem.applyMinionBoost(entity, boostCount);
            }
        }
    }
}

