/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.item.DrinkableItem;

public class NightHeartPeaSoupItem
extends DrinkableItem
implements IWand {
    private static final int MAX_BOOST_COUNT = 5;
    private static final double BOOST_PERCENTAGE = 0.1;
    private static final String SOUP_BOOST_COUNT_TAG = "NightPeaSoupBoostCount";
    private static final String MINION_BOOST_APPLIED_TAG = "NightPeaSoupBoostApplied";
    private static final UUID ATTACK_DAMAGE_BOOST_UUID = UUID.fromString("d03da095-ff85-4c52-a404-51566bdff53e");
    private static final UUID MAX_HEALTH_BOOST_UUID = UUID.fromString("12f30d3e-d988-4b93-af83-8f25dc50f14c");
    private static final UUID ARMOR_BOOST_UUID = UUID.fromString("0cb7577e-778e-4872-9c54-5345668e468f");

    public NightHeartPeaSoupItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.m_5922_(stack, level, entity);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_46469_().m_46207_(GameRules.f_46140_)) {
                serverLevel.m_8615_(18000L + 24000L * (serverLevel.m_46468_() / 24000L + 1L));
                serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.0f, 0.8f);
                for (int i = 0; i < 20; ++i) {
                    double x = entity.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 2.0;
                    double y = entity.m_20186_() + level.f_46441_.m_188500_() * 2.0;
                    double z = entity.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 2.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                SpellStat spellStat = new SpellStat(0, 0, 16, 2.0, 0, 0.0f);
                for (int i = 0; i < 16; ++i) {
                    double d0 = MathHelper.rgbToSpeed((double)96.0);
                    double d1 = MathHelper.rgbToSpeed((double)62.0);
                    double d2 = MathHelper.rgbToSpeed((double)92.0);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CULT_SPELL.get()), player.m_20208_(1.0), player.m_20187_(), player.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
                SEHelper.setEndWalk((Player)player, (BlockPos)player.m_20183_(), (ResourceKey)player.m_9236_().m_46472_());
                ModNetwork.sendTo((Player)player, (Object)new SPlayPlayerSoundPacket((SoundEvent)ModSounds.END_WALK.get(), 1.0f, 1.0f));
                this.increaseSoupBoostCount(player);
                this.applyMinionBoosts(player, NightHeartPeaSoupItem.getSoupBoostCount(player));
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return result;
            }
            if (result.m_41619_()) {
                return new ItemStack((ItemLike)Items.f_42399_);
            }
            if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42399_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_42399_), false);
            }
        }
        return result;
    }

    public SpellType getSpellType() {
        return null;
    }

    public static int getSoupBoostCount(Player player) {
        return player.getPersistentData().m_128451_(SOUP_BOOST_COUNT_TAG);
    }

    private void increaseSoupBoostCount(Player player) {
        int currentCount = NightHeartPeaSoupItem.getSoupBoostCount(player);
        if (currentCount < 5) {
            player.getPersistentData().m_128405_(SOUP_BOOST_COUNT_TAG, currentCount + 1);
        }
    }

    private void applyMinionBoosts(Player player, int boostCount) {
        if (boostCount <= 0) {
            return;
        }
        for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(64.0))) {
            if (!this.isPlayerMinion(entity, player)) continue;
            NightHeartPeaSoupItem.applyMinionBoost(entity, boostCount);
        }
    }

    private boolean isPlayerMinion(LivingEntity entity, Player player) {
        if (entity instanceof IOwned) {
            IOwned ownedEntity = (IOwned)entity;
            LivingEntity owner = ownedEntity.getTrueOwner();
            return owner == player;
        }
        return false;
    }

    public static void applyMinionBoost(LivingEntity minion, int boostCount) {
        AttributeInstance armor;
        AttributeInstance maxHealth;
        if (minion.m_9236_().f_46443_) {
            return;
        }
        CompoundTag persistentData = minion.getPersistentData();
        int currentBoost = persistentData.m_128451_(MINION_BOOST_APPLIED_TAG);
        if (currentBoost >= boostCount) {
            return;
        }
        NightHeartPeaSoupItem.removeMinionBoost(minion);
        double boostMultiplier = 1.0 + 0.1 * (double)boostCount;
        AttributeInstance attackDamage = minion.m_21051_(Attributes.f_22281_);
        if (attackDamage != null) {
            double baseValue = attackDamage.m_22115_();
            double boostValue = baseValue * 0.1 * (double)boostCount;
            attackDamage.m_22125_(new AttributeModifier(ATTACK_DAMAGE_BOOST_UUID, "Night Pea Soup Attack Boost", boostValue, AttributeModifier.Operation.ADDITION));
        }
        if ((maxHealth = minion.m_21051_(Attributes.f_22276_)) != null) {
            double baseValue = maxHealth.m_22115_();
            double boostValue = baseValue * 0.1 * (double)boostCount;
            maxHealth.m_22125_(new AttributeModifier(MAX_HEALTH_BOOST_UUID, "Night Pea Soup Health Boost", boostValue, AttributeModifier.Operation.ADDITION));
            minion.m_21153_(minion.m_21223_() + (float)boostValue);
        }
        if ((armor = minion.m_21051_(Attributes.f_22284_)) != null) {
            double baseValue = armor.m_22115_();
            double boostValue = baseValue * 0.1 * (double)boostCount;
            armor.m_22125_(new AttributeModifier(ARMOR_BOOST_UUID, "Night Pea Soup Armor Boost", boostValue, AttributeModifier.Operation.ADDITION));
        }
        persistentData.m_128405_(MINION_BOOST_APPLIED_TAG, boostCount);
    }

    public static void removeMinionBoost(LivingEntity minion) {
        AttributeInstance armor;
        AttributeInstance maxHealth;
        AttributeInstance attackDamage = minion.m_21051_(Attributes.f_22281_);
        if (attackDamage != null) {
            attackDamage.m_22120_(ATTACK_DAMAGE_BOOST_UUID);
        }
        if ((maxHealth = minion.m_21051_(Attributes.f_22276_)) != null) {
            maxHealth.m_22120_(MAX_HEALTH_BOOST_UUID);
        }
        if ((armor = minion.m_21051_(Attributes.f_22284_)) != null) {
            armor.m_22120_(ARMOR_BOOST_UUID);
        }
    }

    @Mod.EventBusSubscriber
    public static class MinionBoostHandler {
        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Player player;
            int boostCount;
            IOwned ownedEntity;
            LivingEntity owner;
            LivingEntity entity;
            Entity entity2;
            if (!event.getLevel().m_5776_() && (entity2 = event.getEntity()) instanceof LivingEntity && (entity = (LivingEntity)entity2) instanceof IOwned && (owner = (ownedEntity = (IOwned)entity).getTrueOwner()) instanceof Player && (boostCount = NightHeartPeaSoupItem.getSoupBoostCount(player = (Player)owner)) > 0) {
                NightHeartPeaSoupItem.applyMinionBoost(entity, boostCount);
            }
        }
    }
}

