/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.util.EntityTagChecker;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="goetydelight")
public class OminousIceCreamItem
extends Item {
    public static final String OMINOUS_ACTIVE_TAG = "OminousIceCreamActive";
    public static final String HAS_CONSUMED_TAG = "HasConsumedOminousIceCream";

    public OminousIceCreamItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        if (!level.f_46443_ && entity instanceof Player && (player = (Player)entity).m_21023_(MobEffects.f_19594_)) {
            player.getPersistentData().m_128379_(OMINOUS_ACTIVE_TAG, true);
            player.getPersistentData().m_128379_(HAS_CONSUMED_TAG, true);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return resultStack;
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (!(attacker instanceof Mob) || !(target instanceof Player)) {
            return;
        }
        Mob mob = (Mob)attacker;
        Player player = (Player)target;
        if (!EntityTagChecker.isEntityInTag((Entity)mob, "minecraft:raiders") || mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
            return;
        }
        if (player.getPersistentData().m_128471_(OMINOUS_ACTIVE_TAG) && mob.m_21188_() != player) {
            if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                event.setNewTarget(null);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Mob mob;
            LivingEntity attacker;
            Player player = (Player)livingEntity;
            LivingEntity livingEntity2 = attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
            if (attacker instanceof Mob && EntityTagChecker.isEntityInTag((Entity)(mob = (Mob)attacker), "minecraft:raiders") && !mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && player.getPersistentData().m_128471_(OMINOUS_ACTIVE_TAG) && mob.m_21188_() != player) {
                event.setCanceled(true);
                double d0 = mob.m_20185_() - player.m_20185_();
                double d1 = mob.m_20189_() - player.m_20189_();
                mob.m_21573_().m_26573_();
                mob.m_20256_(mob.m_20184_().m_82520_(Math.signum(d0) * 0.1, 0.0, Math.signum(d1) * 0.1));
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 0.5f, 1.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.m_19544_() == MobEffects.f_19594_ && player.getPersistentData().m_128471_(OMINOUS_ACTIVE_TAG)) {
                player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.m_19544_() == MobEffects.f_19594_ && player.getPersistentData().m_128471_(OMINOUS_ACTIVE_TAG)) {
                player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12563_, SoundSource.PLAYERS, 0.8f, 1.2f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
            player.getPersistentData().m_128473_(HAS_CONSUMED_TAG);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
        player.getPersistentData().m_128473_(HAS_CONSUMED_TAG);
    }
}

