/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.item.ModItems;
import net.v_black_cat.goetydelight.item.food.BowlFoodItem;

@Mod.EventBusSubscriber(modid="goetydelight")
public class SevenLeafPuddingItem
extends BowlFoodItem {
    private static final UUID ATTACK_DAMAGE_BONUS_UUID = UUID.fromString("d3b1a8c2-4e5f-6a7b-8c9d-0e1f2a3b4c5d");
    private static final UUID MOVEMENT_SPEED_BONUS_UUID = UUID.fromString("a5b4c3d2-1f0e-9a8b-7c6d-5e4f3a2b1c0d");
    private static final String BONUS_ACTIVE_TAG = "SevenLeafPuddingActive";
    private static final String ACTIVATION_TIME_TAG = "SevenLeafPuddingActivationTime";
    private static final int DURATION_TICKS = 6000;

    public SevenLeafPuddingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag persistentData = player.getPersistentData();
            if (persistentData.m_128471_(BONUS_ACTIVE_TAG)) {
                this.removeBonusAttributes(player);
            }
            this.addBonusAttributes(player);
            persistentData.m_128379_(BONUS_ACTIVE_TAG, true);
            persistentData.m_128356_(ACTIVATION_TIME_TAG, level.m_46467_());
        }
        return resultStack;
    }

    private void addBonusAttributes(Player player) {
        AttributeInstance movementSpeed;
        AttributeInstance attackDamage = player.m_21051_(Attributes.f_22281_);
        if (attackDamage != null) {
            AttributeModifier modifier = new AttributeModifier(ATTACK_DAMAGE_BONUS_UUID, "Seven Leaf Pudding Attack Bonus", 3.0, AttributeModifier.Operation.ADDITION);
            attackDamage.m_22118_(modifier);
        }
        if ((movementSpeed = player.m_21051_(Attributes.f_22279_)) != null) {
            AttributeModifier modifier = new AttributeModifier(MOVEMENT_SPEED_BONUS_UUID, "Seven Leaf Pudding Speed Bonus", 0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);
            movementSpeed.m_22118_(modifier);
        }
    }

    private void removeBonusAttributes(Player player) {
        AttributeInstance movementSpeed;
        AttributeInstance attackDamage = player.m_21051_(Attributes.f_22281_);
        if (attackDamage != null && attackDamage.m_22111_(ATTACK_DAMAGE_BONUS_UUID) != null) {
            attackDamage.m_22120_(ATTACK_DAMAGE_BONUS_UUID);
        }
        if ((movementSpeed = player.m_21051_(Attributes.f_22279_)) != null && movementSpeed.m_22111_(MOVEMENT_SPEED_BONUS_UUID) != null) {
            movementSpeed.m_22120_(MOVEMENT_SPEED_BONUS_UUID);
        }
        player.getPersistentData().m_128473_(BONUS_ACTIVE_TAG);
        player.getPersistentData().m_128473_(ACTIVATION_TIME_TAG);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        CompoundTag persistentData;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!level.f_46443_ && (persistentData = player.getPersistentData()).m_128471_(BONUS_ACTIVE_TAG)) {
            long activationTime = persistentData.m_128454_(ACTIVATION_TIME_TAG);
            long currentTime = level.m_46467_();
            if (currentTime - activationTime >= 6000L) {
                SevenLeafPuddingItem item = (SevenLeafPuddingItem)((Object)ModItems.SEVEN_LEAF_PUDDING.get());
                item.removeBonusAttributes(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SevenLeafPuddingItem item = (SevenLeafPuddingItem)((Object)ModItems.SEVEN_LEAF_PUDDING.get());
            if (player.getPersistentData().m_128471_(BONUS_ACTIVE_TAG)) {
                item.removeBonusAttributes(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getPersistentData().m_128473_(BONUS_ACTIVE_TAG);
        player.getPersistentData().m_128473_(ACTIVATION_TIME_TAG);
    }
}

