/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class SiblingSundaeItem
extends Item {
    public SiblingSundaeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        if (!level.f_46443_) {
            Cat cat;
            double v;
            int checkedLevel;
            TagKey[] servantTags = new TagKey[]{TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("goetydelight", "servants_pool/servants_pool_1")), TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("goetydelight", "servants_pool/servants_pool_2")), TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("goetydelight", "servants_pool/servants_pool_3")), TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("goetydelight", "servants_pool/servants_pool_4")), TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("goetydelight", "servants_pool/servants_pool_5")), TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("goetydelight", "servants_pool/servants_pool_6"))};
            double[] weights = new double[]{50.0, 35.0, 12.5, 2.25, 0.24, 0.01};
            int[] summonCounts = new int[]{8, 4, 2, 1, 1, 1};
            int[] lifeTimes = new int[]{2400, 6000, 12000, 36000, 72000, 144000};
            double[] immortalBaseChance = new double[]{0.5, 0.5, 0.5, 0.3, 0.2, 0.1};
            int luck = 0;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                luck = (int)player.m_21051_(Attributes.f_22286_).m_22135_();
            }
            int rollTimes = 1 + Math.min(luck / 3, 4);
            int bestLevel = 0;
            Random random = new Random();
            for (int i = 0; i < rollTimes; ++i) {
                int level1 = this.rollLevel(weights, random);
                if (level1 <= bestLevel) continue;
                bestLevel = level1;
            }
            ArrayList servantTypes = new ArrayList();
            for (checkedLevel = bestLevel; checkedLevel >= 0; --checkedLevel) {
                servantTypes.clear();
                BuiltInRegistries.f_256780_.m_203431_(servantTags[checkedLevel]).ifPresent(tag -> {
                    for (Holder holder : tag) {
                        servantTypes.add((EntityType)holder.m_203334_());
                    }
                });
                if (!servantTypes.isEmpty()) break;
            }
            if (!servantTypes.isEmpty()) {
                int summonCount = summonCounts[checkedLevel];
                double servantImmortalChance = immortalBaseChance[checkedLevel] + (double)Math.min(luck, 50) * 0.01;
                servantImmortalChance = checkedLevel == 4 ? Math.min(servantImmortalChance, 0.2) : Math.min(servantImmortalChance, 1.0);
                for (int summonIdx = 0; summonIdx < summonCount; ++summonIdx) {
                    EntityType servantTypeToSummon = null;
                    Entity entityToSummon = null;
                    for (int tryCount = 0; tryCount < 10 && (entityToSummon = (servantTypeToSummon = (EntityType)servantTypes.get(random.nextInt(servantTypes.size()))).m_20615_(level)) == null; ++tryCount) {
                    }
                    if (entityToSummon == null) continue;
                    boolean isImmortal = random.nextDouble() < servantImmortalChance;
                    int servantLife = isImmortal ? -1 : lifeTimes[checkedLevel];
                    this.createAndSetupServant((EntityType<? extends Entity>)servantTypeToSummon, level, entity, servantLife);
                }
            }
            if (bestLevel >= 4 && (v = random.nextDouble()) < 0.33 && (cat = (Cat)EntityType.f_20553_.m_20615_(level)) != null) {
                ServerLevel serverLevel;
                CatVariant allBlack;
                if (level instanceof ServerLevel && (allBlack = (CatVariant)(serverLevel = (ServerLevel)level).m_9598_().m_175515_(Registries.f_257006_).m_7745_(new ResourceLocation("minecraft", "all_black"))) != null) {
                    cat.m_28464_(allBlack);
                }
                cat.m_6593_((Component)Component.m_237113_((String)"V_BlackCAT"));
                cat.m_20340_(true);
                cat.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
                cat.m_20331_(true);
                level.m_7967_((Entity)cat);
            }
        }
        return resultStack;
    }

    private int rollLevel(double[] weights, Random random) {
        double total = 0.0;
        for (double w : weights) {
            total += w;
        }
        double r = random.nextDouble() * total;
        double acc = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            if (!(r < (acc += weights[i]))) continue;
            return i;
        }
        return weights.length - 1;
    }

    private void createAndSetupServant(EntityType<? extends Entity> servantType, Level level, LivingEntity owner, int lifeTicks) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = servantType.m_20615_(level);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (entity instanceof IOwned) {
                    IOwned owned = (IOwned)entity;
                    mob.m_6034_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
                    owned.setTrueOwner(owner);
                    if (lifeTicks > 0) {
                        owned.setLimitedLife(lifeTicks);
                        owned.setHasLifespan(true);
                    }
                    mob.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(mob.m_20183_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                    this.processHealthAndEffects(mob);
                    level.m_7967_((Entity)mob);
                }
            }
        }
    }

    private void processHealthAndEffects(Mob servant) {
        int healthDeficit;
        int healthBoostLevel;
        float maxHealth = servant.m_21233_();
        if (maxHealth < 60.0f && (healthBoostLevel = (healthDeficit = (int)(60.0f - maxHealth)) / 3) > 0) {
            servant.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), 1200, healthBoostLevel - 1, false, true));
        }
    }
}

