/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import com.Polarice3.Goety.utils.LichdomHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SundaeOfThePhilosophersPotionItem
extends Item {
    private static final String MINING_SPEED_BOOST_TAG = "PhilosopherSundaeMiningSpeedBoost";
    private static final String MAGIC_RESISTANCE_BOOST_TAG = "PhilosopherSundaeMagicResistanceBoost";
    private static final int MAX_MINING_BOOST_COUNT = 3;
    private static final int MAX_MAGIC_RESISTANCE_COUNT = 1;

    public SundaeOfThePhilosophersPotionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (LichdomHelper.isLich((Player)player)) {
            return super.m_7203_(level, player, usedHand);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(usedHand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack result = super.m_5922_(stack, level, livingEntity);
        if (!level.f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyMiningSpeedBoost(player);
            this.applyMagicResistanceBoost(player);
        }
        return result;
    }

    private void applyMiningSpeedBoost(Player player) {
        int currentCount = SundaeOfThePhilosophersPotionItem.getMiningSpeedBoostCount(player);
        if (currentCount < 3) {
            player.getPersistentData().m_128405_(MINING_SPEED_BOOST_TAG, currentCount + 1);
        }
    }

    private void applyMagicResistanceBoost(Player player) {
        int currentCount = SundaeOfThePhilosophersPotionItem.getMagicResistanceBoostCount(player);
        if (currentCount < 1) {
            player.getPersistentData().m_128405_(MAGIC_RESISTANCE_BOOST_TAG, currentCount + 1);
        }
    }

    public static int getMiningSpeedBoostCount(Player player) {
        return player.getPersistentData().m_128451_(MINING_SPEED_BOOST_TAG);
    }

    public static int getMagicResistanceBoostCount(Player player) {
        return player.getPersistentData().m_128451_(MAGIC_RESISTANCE_BOOST_TAG);
    }

    @Mod.EventBusSubscriber
    public static class MagicResistanceHandler {
        @SubscribeEvent
        public static void onMagicDamage(LivingHurtEvent event) {
            Player player;
            int resistanceCount;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && (resistanceCount = SundaeOfThePhilosophersPotionItem.getMagicResistanceBoostCount(player = (Player)livingEntity)) > 0 && MagicResistanceHandler.isMagicDamage(event.getSource())) {
                float originalDamage = event.getAmount();
                float reducedDamage = originalDamage * 0.5f;
                event.setAmount(reducedDamage);
            }
        }

        private static boolean isMagicDamage(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268493_) || source.m_276093_(DamageTypes.f_268482_) || source.m_276093_(DamageTypes.f_268530_);
        }
    }

    @Mod.EventBusSubscriber
    public static class MiningSpeedHandler {
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            Block block;
            Player player = event.getEntity();
            int boostCount = SundaeOfThePhilosophersPotionItem.getMiningSpeedBoostCount(player);
            if (boostCount > 0 && MiningSpeedHandler.isBreakableBlock(block = event.getState().m_60734_())) {
                float originalSpeed = event.getOriginalSpeed();
                float boostedSpeed = originalSpeed * (1.0f + 0.1f * (float)boostCount);
                event.setNewSpeed(boostedSpeed);
            }
        }

        private static boolean isBreakableBlock(Block block) {
            return true;
        }
    }
}

