/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.v_black_cat.goetydelight.item.ItemBlackList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Inject(method={"fromJson(Lnet/minecraft/resources/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraftforge/common/crafting/conditions/ICondition$IContext;)Lnet/minecraft/world/item/crafting/Recipe;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void skipBlacklistedRecipes(ResourceLocation recipeId, JsonObject json, ICondition.IContext context, CallbackInfoReturnable<Recipe<?>> cir) {
        if (RecipeManagerMixin.isRecipeBlacklisted(json)) {
            cir.setReturnValue(null);
        }
    }

    private static boolean isRecipeBlacklisted(JsonObject json) {
        String itemId;
        JsonArray ingredientsArray;
        if (json.has("result")) {
            String itemFromObj;
            JsonObject resultObj;
            JsonElement resultElement = json.get("result");
            String resultItem = RecipeManagerMixin.getItemIdFromJsonElement(resultElement);
            if (resultItem != null && ItemBlackList.isBlackListed(resultItem)) {
                return true;
            }
            if (resultElement.isJsonObject() && (resultObj = resultElement.getAsJsonObject()).has("item") && (itemFromObj = RecipeManagerMixin.getItemIdFromJsonElement(resultObj.get("item"))) != null && ItemBlackList.isBlackListed(itemFromObj)) {
                return true;
            }
        }
        if (json.has("ingredients") && json.get("ingredients").isJsonArray()) {
            ingredientsArray = json.getAsJsonArray("ingredients");
            for (JsonElement ingredientElement : ingredientsArray) {
                String nestedItem;
                JsonObject ingredientObj;
                itemId = RecipeManagerMixin.getItemIdFromJsonElement(ingredientElement);
                if (itemId != null && ItemBlackList.isBlackListed(itemId)) {
                    return true;
                }
                if (!ingredientElement.isJsonObject() || !(ingredientObj = ingredientElement.getAsJsonObject()).has("item") || (nestedItem = RecipeManagerMixin.getItemIdFromJsonElement(ingredientObj.get("item"))) == null || !ItemBlackList.isBlackListed(nestedItem)) continue;
                return true;
            }
        }
        if (json.has("ingredient")) {
            String nestedItem;
            JsonObject ingredientObj;
            JsonElement ingredientElement = json.get("ingredient");
            String itemId2 = RecipeManagerMixin.getItemIdFromJsonElement(ingredientElement);
            if (itemId2 != null && ItemBlackList.isBlackListed(itemId2)) {
                return true;
            }
            if (ingredientElement.isJsonObject() && (ingredientObj = ingredientElement.getAsJsonObject()).has("item") && (nestedItem = RecipeManagerMixin.getItemIdFromJsonElement(ingredientObj.get("item"))) != null && ItemBlackList.isBlackListed(nestedItem)) {
                return true;
            }
        }
        if (json.has("key") && json.get("key").isJsonObject()) {
            JsonObject keyObj = json.getAsJsonObject("key");
            for (String key : keyObj.keySet()) {
                JsonElement keyElement = keyObj.get(key);
                String itemId3 = RecipeManagerMixin.getItemIdFromJsonElement(keyElement);
                if (itemId3 == null || !ItemBlackList.isBlackListed(itemId3)) continue;
                return true;
            }
        }
        if (json.has("ingredients") && json.get("ingredients").isJsonArray()) {
            ingredientsArray = json.getAsJsonArray("ingredients");
            for (JsonElement ingredientElement : ingredientsArray) {
                itemId = RecipeManagerMixin.getItemIdFromJsonElement(ingredientElement);
                if (itemId == null || !ItemBlackList.isBlackListed(itemId)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getItemIdFromJsonElement(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return element.getAsString();
        }
        if (element.isJsonObject()) {
            JsonObject nestedItem;
            JsonObject jsonObj = element.getAsJsonObject();
            if (jsonObj.has("item") && jsonObj.get("item").isJsonPrimitive()) {
                return jsonObj.get("item").getAsString();
            }
            if (jsonObj.has("item") && jsonObj.get("item").isJsonObject() && (nestedItem = jsonObj.getAsJsonObject("item")).has("item") && nestedItem.get("item").isJsonPrimitive()) {
                return nestedItem.get("item").getAsString();
            }
            if (jsonObj.has("name") && jsonObj.get("name").isJsonPrimitive()) {
                return jsonObj.get("name").getAsString();
            }
        }
        return null;
    }
}

