/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncAbilityPacket {
    private final int entityId;
    private final String abilityId;
    private final boolean add;

    public SyncAbilityPacket(int entityId, String abilityId, boolean add) {
        this.entityId = entityId;
        this.abilityId = abilityId;
        this.add = add;
    }

    public static void encode(SyncAbilityPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.m_130070_(msg.abilityId);
        buffer.writeBoolean(msg.add);
    }

    public static SyncAbilityPacket decode(FriendlyByteBuf buffer) {
        return new SyncAbilityPacket(buffer.readInt(), buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(SyncAbilityPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            Entity entity = mc.f_91073_.m_6815_(msg.entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (msg.add) {
                    livingEntity.getPersistentData().m_128379_("ClientSide_" + msg.abilityId, true);
                } else {
                    livingEntity.getPersistentData().m_128473_("ClientSide_" + msg.abilityId);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

