/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.patchouli;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CookingPotRecipeProcessor
implements IComponentProcessor {
    private CookingPotRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        this.recipe = level.m_7465_().m_44043_(id).filter(r -> r.m_6671_() == ModRecipeTypes.COOKING.get()).map(r -> (CookingPotRecipe)r).orElse(null);
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "input0": {
                return this.getIngredientStack(0);
            }
            case "input1": {
                return this.getIngredientStack(1);
            }
            case "input2": {
                return this.getIngredientStack(2);
            }
            case "input3": {
                return this.getIngredientStack(3);
            }
            case "input4": {
                return this.getIngredientStack(4);
            }
            case "input5": {
                return this.getIngredientStack(5);
            }
            case "output": {
                return IVariable.from((Object)this.recipe.m_8043_(level.m_9598_()));
            }
            case "container": {
                return IVariable.from((Object)this.recipe.getOutputContainer());
            }
            case "cookTime": {
                return IVariable.wrap((Number)this.recipe.getCookTime());
            }
            case "experience": {
                return IVariable.wrap((Number)Float.valueOf(this.recipe.getExperience()));
            }
        }
        return null;
    }

    private IVariable getIngredientStack(int index) {
        NonNullList ingredients = this.recipe.m_7527_();
        if (index >= ingredients.size()) {
            return IVariable.from((Object)ItemStack.f_41583_);
        }
        Ingredient ingredient = (Ingredient)ingredients.get(index);
        ItemStack[] items = ingredient.m_43908_();
        if (items.length > 0) {
            return IVariable.from((Object)items[0]);
        }
        return IVariable.from((Object)ItemStack.f_41583_);
    }
}

