/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.ritual;

import com.Polarice3.Goety.api.ritual.IRitualType;
import com.Polarice3.Goety.api.ritual.RitualType;
import com.Polarice3.Goety.common.blocks.entities.DarkAltarBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.RitualBlockEntity;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.items.ModItems;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.v_black_cat.goetydelight.block.ModBlocks;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class DelightRitualType
implements IRitualType {
    public String getName() {
        return "culinary";
    }

    public ItemStack getJeiIcon() {
        return new ItemStack((ItemLike)ModBlocks.CURSED_INGOT_POT.get());
    }

    public boolean getRequirement(RitualBlockEntity tileEntity, BlockPos pos, Level level) {
        return this.checkDelightRequirements(pos, level);
    }

    private boolean checkDelightRequirements(BlockPos pos, Level level) {
        int RANGE = 5;
        HashMap<Block, Integer> blockRequirements = new HashMap<Block, Integer>();
        blockRequirements.put(Blocks.f_50619_, 2);
        blockRequirements.put((Block)ModBlocks.SHADE_STOVE.get(), 1);
        blockRequirements.put((Block)ModBlocks.CURSED_INGOT_POT.get(), 1);
        HashMap<Block, Integer> blockCounts = new HashMap<Block, Integer>();
        for (Block block : blockRequirements.keySet()) {
            blockCounts.put(block, 0);
        }
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                for (int k = -5; k <= 5; ++k) {
                    BlockPos checkPos = pos.m_7918_(i, j, k);
                    BlockState state = level.m_8055_(checkPos);
                    Block block = state.m_60734_();
                    if (!blockRequirements.containsKey(block)) continue;
                    blockCounts.put(block, (Integer)blockCounts.get(block) + 1);
                }
            }
        }
        for (Map.Entry entry : blockRequirements.entrySet()) {
            Block block = (Block)entry.getKey();
            int requiredCount = (Integer)entry.getValue();
            int actualCount = (Integer)blockCounts.get(block);
            if (actualCount >= requiredCount) continue;
            return false;
        }
        return true;
    }

    public void onFinishRitual(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        RitualRecipe recipe = tileEntity.getCurrentRitualRecipe();
        if (recipe.m_6423_().toString().equals("goetydelight:ominous_ramune")) {
            this.returnSpecialItems(world, darkAltarPos, castingPlayer, new ItemStack((ItemLike)ModItems.OMINOUS_ORB.get()));
            this.returnSpecialItems(world, darkAltarPos, castingPlayer, new ItemStack((ItemLike)ModItems.BOUNCY_BUBBLE_FOCUS.get()));
        }
        if (recipe.m_6423_().toString().equals("goetydelight:ominous_ramune_2")) {
            this.returnSpecialItems(world, darkAltarPos, castingPlayer, new ItemStack((ItemLike)ModItems.OMINOUS_SHARD.get()));
            this.returnSpecialItems(world, darkAltarPos, castingPlayer, new ItemStack((ItemLike)ModItems.BOUNCY_BUBBLE_FOCUS.get()));
        }
        world.m_5594_(null, darkAltarPos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 0.5f);
        for (int i = 0; i < 20; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123750_, (double)darkAltarPos.m_123341_() + 0.5 + world.f_46441_.m_188583_() * 0.5, (double)darkAltarPos.m_123342_() + 1.5, (double)darkAltarPos.m_123343_() + 0.5 + world.f_46441_.m_188583_() * 0.5, 0.0, 0.1, 0.0);
        }
    }

    private void returnSpecialItems(Level world, BlockPos darkAltarPos, Player player, ItemStack returnItem) {
        if (!player.m_150109_().m_36054_(returnItem)) {
            player.m_36176_(returnItem, false);
        }
        world.m_5594_(null, darkAltarPos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void registerRitualType() {
        DelightRitualType delightRitualType = new DelightRitualType();
        Optional goetyContainer = ModList.get().getModContainerById("goety");
        if (goetyContainer.isPresent()) {
            DefaultArtifactVersion requiredVersion;
            DefaultArtifactVersion loadedVersion = (DefaultArtifactVersion)((ModContainer)goetyContainer.get()).getModInfo().getVersion();
            if (loadedVersion.compareTo((ArtifactVersion)(requiredVersion = new DefaultArtifactVersion("2.5.38.0"))) >= 0) {
                RitualType.addRitualType((String)"culinary", (IRitualType)delightRitualType);
            } else {
                try {
                    Method createMethod = RitualType.class.getDeclaredMethod("create", String.class, IRitualType.class);
                    createMethod.setAccessible(true);
                    createMethod.invoke(null, "DELIGHT", delightRitualType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

