/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.v_black_cat.goetydelight.structures.ModStructures;
import net.v_black_cat.goetydelight.structures.pieces.EctoplasmicMelonFieldPiece;

public class EctoplasmicMelonFieldStructure
extends Structure {
    public static final Codec<EctoplasmicMelonFieldStructure> CODEC = EctoplasmicMelonFieldStructure.m_226607_(EctoplasmicMelonFieldStructure::new);

    public EctoplasmicMelonFieldStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return EctoplasmicMelonFieldStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    private int getAverageHeight(Structure.GenerationContext context) {
        int totalHeight = 0;
        int sampleCount = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = context.f_226628_().m_45604_() + x;
                int worldZ = context.f_226628_().m_45605_() + z;
                int height = context.f_226622_().m_223221_(worldX, worldZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
                totalHeight += height;
                ++sampleCount;
            }
        }
        return sampleCount > 0 ? totalHeight / sampleCount : 0;
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int y = this.getAverageHeight(context);
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), y, context.f_226628_().m_45605_());
        int variant = context.f_226626_().m_188503_(3);
        builder.m_142679_((StructurePiece)new EctoplasmicMelonFieldPiece(context.f_226625_(), blockpos, variant));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructures.ECTOPLASMIC_MELON_FIELD.get();
    }
}

