/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.structures.pieces;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.v_black_cat.goetydelight.GoetyDelight;
import net.v_black_cat.goetydelight.structures.ChestLootProcessor;
import net.v_black_cat.goetydelight.structures.ModStructurePieceTypes;
import net.v_black_cat.goetydelight.structures.SmartBottomProtectionProcessor;

public class EctoplasmicMelonFieldPiece
extends StructurePiece {
    private final int variant;
    private final ResourceLocation templateLocation;

    public EctoplasmicMelonFieldPiece(StructureTemplateManager pTemplateManager, BlockPos pPos, int variant) {
        super((StructurePieceType)ModStructurePieceTypes.ECTOPLASMIC_MELON_FIELD_PIECE.get(), 0, EctoplasmicMelonFieldPiece.createBoundingBox(pTemplateManager, pPos, variant));
        this.variant = variant;
        this.templateLocation = EctoplasmicMelonFieldPiece.getTemplateForVariant(variant);
        this.m_73519_(Direction.NORTH);
    }

    public EctoplasmicMelonFieldPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)ModStructurePieceTypes.ECTOPLASMIC_MELON_FIELD_PIECE.get(), tag);
        this.variant = tag.m_128451_("Variant");
        this.templateLocation = EctoplasmicMelonFieldPiece.getTemplateForVariant(this.variant);
    }

    private static BoundingBox createBoundingBox(StructureTemplateManager templateManager, BlockPos pPos, int variant) {
        ResourceLocation templateLocation = EctoplasmicMelonFieldPiece.getTemplateForVariant(variant);
        StructureTemplate template = templateManager.m_230407_(templateLocation).orElse(null);
        if (template != null) {
            int sizeX = template.m_163801_().m_123341_();
            int sizeZ = template.m_163801_().m_123343_();
            return new BoundingBox(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_(), pPos.m_123341_() + sizeX - 1, pPos.m_123342_() + template.m_163801_().m_123342_(), pPos.m_123343_() + sizeZ - 1);
        }
        return new BoundingBox(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_(), pPos.m_123341_() + 16 - 1, pPos.m_123342_() + 10, pPos.m_123343_() + 10 - 1);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("Variant", this.variant);
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        ResourceLocation templateLocation;
        StructureTemplateManager templateManager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate template = templateManager.m_230407_(templateLocation = EctoplasmicMelonFieldPiece.getTemplateForVariant(this.variant)).orElse(null);
        if (template == null) {
            GoetyDelight.LOGGER.error("Template not found: {}", (Object)templateLocation);
            return;
        }
        StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_74379_(this.m_6830_()).m_74377_(this.m_163587_()).m_74381_(box).m_74392_(false).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_).m_74383_((StructureProcessor)new SmartBottomProtectionProcessor(2)).m_74383_((StructureProcessor)new ChestLootProcessor()).m_74405_(true);
        BlockPos placementPos = new BlockPos(this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 2, this.f_73383_.m_162398_());
        template.m_230328_((ServerLevelAccessor)level, placementPos, placementPos, placementSettings, random, 2);
    }

    private static ResourceLocation getTemplateForVariant(int variant) {
        return switch (variant) {
            case 0 -> new ResourceLocation("goetydelight", "ectoplasmic_melon_field_variant_a");
            case 1 -> new ResourceLocation("goetydelight", "ectoplasmic_melon_field_variant_b");
            case 2 -> new ResourceLocation("goetydelight", "ectoplasmic_melon_field_variant_c");
            default -> new ResourceLocation("goetydelight", "ectoplasmic_melon_field_variant_a");
        };
    }
}

