/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats;

import com.interordi.iobattlestats.IOBattleStats;
import com.interordi.iobattlestats.structures.BattleKey;
import com.interordi.iobattlestats.structures.StatKey;
import com.interordi.iobattlestats.structures.StatUpdate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class DataAccess
implements Runnable {
    private IOBattleStats plugin;
    private String database = "";
    private String tablePrefix = "stats_io_";
    private Map<BattleKey, Float> damages = new HashMap<BattleKey, Float>();
    private Map<BattleKey, Integer> deaths = new HashMap<BattleKey, Integer>();
    private Vector<StatUpdate> basicStats = new Vector();
    private Vector<StatUpdate> maxStats = new Vector();
    private static final int maxNameLength = 100;

    DataAccess(IOBattleStats plugin, String dbHost, int dbPort, String dbUsername, String dbPassword, String dbBase) {
        this.plugin = plugin;
        this.database = "jdbc:mysql://" + dbHost + ":" + dbPort + "/" + dbBase + "?user=" + dbUsername + "&password=" + dbPassword + "&useSSL=false";
    }

    public boolean init() {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String query = "";
        try {
            conn = DriverManager.getConnection(this.database);
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "arrows` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "beds_entered` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "blocks_broken` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "blocks_placed` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "buckets_emptied` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "buckets_filled` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "change_world` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "chat_words` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "commands` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "consumed` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "crafted` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "damage` ( " + "  `source` varchar(36) NOT NULL, " + "  `target` varchar(36) NOT NULL, " + "  `world` varchar(50) NOT NULL, " + "  `cause` varchar(36) NOT NULL, " + "  `weapon_name` varchar(100) NOT NULL, " + "  `damage` float NOT NULL, " + "  `player_source` tinyint(1) NOT NULL, " + "  `player_target` tinyint(1) NOT NULL, " + "  PRIMARY KEY (`source`,`target`,`world`,`cause`,`weapon_name`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "deaths` ( " + "  `source` varchar(36) NOT NULL, " + "  `target` varchar(36) NOT NULL, " + "  `world` varchar(50) NOT NULL, " + "  `cause` varchar(36) NOT NULL, " + "  `weapon_name` varchar(100) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `player_source` tinyint(1) NOT NULL, " + "  `player_target` tinyint(1) NOT NULL, " + "  KEY `main` (`source`,`target`,`world`,`cause`,`weapon_name`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "eggs_thrown` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "fish_caught` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "item_broken` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "item_dropped` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "item_picked_up` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(36) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "joins` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "kicks` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "move` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "players` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `name` varchar(16) NOT NULL, " + "  `ip` varchar(16) NOT NULL, " + "  PRIMARY KEY (`uuid`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "pvp_streak` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `value` int(11) NOT NULL, " + "  PRIMARY KEY (`uuid`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "shears` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "teleports` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "trades` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "xp_gained` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "tamings` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "inventories` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "heals` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "hunger_refills` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "milk` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "splashes` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(50) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "enchants` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "lighters` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "enderpearls` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `name` varchar(100) NOT NULL, " + "  `world` varchar(30) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`,`name`,`world`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "maxes` ( " + "  `uuid` varchar(36) NOT NULL, " + "  `value` varchar(20) NOT NULL, " + "  `amount` int(11) NOT NULL, " + "  PRIMARY KEY (`uuid`,`value`) " + ") ENGINE=InnoDB DEFAULT CHARSET=latin1; ");
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            Bukkit.getLogger().severe("Query: " + query);
            Bukkit.getLogger().severe("SQLException: " + ex.getMessage());
            Bukkit.getLogger().severe("SQLState: " + ex.getSQLState());
            Bukkit.getLogger().severe("VendorError: " + ex.getErrorCode());
            return false;
        }
        return true;
    }

    public void recordDamage(String source, String target, String world, float damage, String cause, String weaponName, boolean playerSource, boolean playerTarget) {
        int isPlayerSource = playerSource ? 1 : 0;
        int isPlayerTarget = playerTarget ? 1 : 0;
        BattleKey bk = new BattleKey(source, target, world, cause, weaponName, isPlayerSource, isPlayerTarget);
        Float val = this.damages.get(bk);
        val = val == null ? Float.valueOf(damage) : Float.valueOf(val.floatValue() + damage);
        this.damages.put(bk, val);
    }

    public void recordDeath(String source, String target, String world, String cause, String weaponName, boolean playerSource, boolean playerTarget) {
        int isPlayerSource = playerSource ? 1 : 0;
        int isPlayerTarget = playerTarget ? 1 : 0;
        BattleKey bk = new BattleKey(source, target, world, cause, weaponName, isPlayerSource, isPlayerTarget);
        Integer val = this.deaths.get(bk);
        val = val == null ? Integer.valueOf(1) : Integer.valueOf(val + 1);
        this.deaths.put(bk, val);
    }

    public void recordBasicStat(String table, UUID uuid, int amount, String world) {
        this.basicStats.add(new StatUpdate(1, table, uuid, amount, world));
    }

    public void recordItemStat(String table, UUID uuid, String value, int amount, String world) {
        this.basicStats.add(new StatUpdate(2, table, uuid, amount, world, value));
    }

    public void recordItemNamedStat(String table, UUID uuid, String value, String name, int amount, String world) {
        this.basicStats.add(new StatUpdate(3, table, uuid, amount, world, value, name));
    }

    public void recordMaxStat(String value, UUID uuid, int amount) {
        this.maxStats.add(new StatUpdate(5, value, uuid, amount));
    }

    public void recordPlayer(UUID uuid, String name, String ip) {
        StatUpdate playerData = new StatUpdate(4, "players", uuid, name);
        playerData.setExtra(ip);
        this.basicStats.add(playerData);
    }

    public void loadStats(Player player) {
    }

    public void saveStats(Player player) {
    }

    @Override
    public void run() {
        HashMap<BattleKey, Float> damagesCopy = new HashMap<BattleKey, Float>();
        damagesCopy.putAll(this.damages);
        this.damages.clear();
        HashMap<BattleKey, Integer> deathsCopy = new HashMap<BattleKey, Integer>();
        deathsCopy.putAll(this.deaths);
        this.deaths.clear();
        Vector<StatUpdate> basicStatsCopy = new Vector<StatUpdate>();
        basicStatsCopy.addAll(this.basicStats);
        this.basicStats.clear();
        Vector<StatUpdate> maxStatsCopy = new Vector<StatUpdate>();
        maxStatsCopy.addAll(this.maxStats);
        this.maxStats.clear();
        HashMap<String, Integer> formats = new HashMap<String, Integer>();
        HashMap basicStructured = new HashMap();
        for (StatUpdate entry : basicStatsCopy) {
            HashMap<StatKey, Integer> tableStats = (HashMap<StatKey, Integer>)basicStructured.get(entry.table);
            if (tableStats == null) {
                tableStats = new HashMap<StatKey, Integer>();
            }
            StatKey statKey = new StatKey(entry.uuid, entry.world, entry.value, entry.name, entry.extra);
            int newAmount = entry.amount;
            if (tableStats.containsKey(statKey)) {
                newAmount += ((Integer)tableStats.get(statKey)).intValue();
            }
            tableStats.put(statKey, newAmount);
            basicStructured.put(entry.table, tableStats);
            formats.put(entry.table, entry.format);
        }
        Connection conn = null;
        String query = "";
        try {
            int n;
            String weaponName;
            Number val;
            BattleKey bk;
            conn = DriverManager.getConnection(this.database);
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO " + this.tablePrefix + "damage (source, target, world, cause, damage, weapon_name, player_source, player_target)" + "VALUES (?, ?, ?, ?, ?, ?, ?, ?) " + "ON DUPLICATE KEY UPDATE damage = damage + ?");
            for (Map.Entry entry : damagesCopy.entrySet()) {
                bk = (BattleKey)entry.getKey();
                val = (Float)entry.getValue();
                weaponName = bk.weaponName;
                if (weaponName.length() > 100) {
                    weaponName = weaponName.substring(0, 100);
                }
                pstmt.setString(1, bk.source);
                pstmt.setString(2, bk.target);
                pstmt.setString(3, bk.world);
                pstmt.setString(4, bk.cause);
                pstmt.setFloat(5, ((Float)val).floatValue());
                pstmt.setString(6, weaponName);
                pstmt.setInt(7, bk.isPlayerSource);
                pstmt.setInt(8, bk.isPlayerTarget);
                pstmt.setFloat(9, ((Float)val).floatValue());
                n = pstmt.executeUpdate();
            }
            pstmt = conn.prepareStatement("INSERT INTO " + this.tablePrefix + "deaths (source, target, world, cause, amount, weapon_name, player_source, player_target)" + "VALUES (?, ?, ?, ?, ?, ?, ?, ?) " + "ON DUPLICATE KEY UPDATE amount = amount + ?");
            for (Map.Entry entry : deathsCopy.entrySet()) {
                bk = (BattleKey)entry.getKey();
                val = (Integer)entry.getValue();
                weaponName = bk.weaponName;
                if (weaponName.length() > 100) {
                    weaponName = weaponName.substring(0, 100);
                }
                pstmt.setString(1, bk.source);
                pstmt.setString(2, bk.target);
                pstmt.setString(3, bk.world);
                pstmt.setString(4, bk.cause);
                pstmt.setFloat(5, ((Integer)val).intValue());
                pstmt.setString(6, weaponName);
                pstmt.setInt(7, bk.isPlayerSource);
                pstmt.setInt(8, bk.isPlayerTarget);
                pstmt.setFloat(9, ((Integer)val).intValue());
                n = pstmt.executeUpdate();
            }
            for (Map.Entry entry : basicStructured.entrySet()) {
                String table = (String)entry.getKey();
                int format = (Integer)formats.get(table);
                if (format == 1) {
                    query = "INSERT INTO " + this.tablePrefix + table + " (uuid, world, amount)" + "VALUES (?, ?, ?) " + "ON DUPLICATE KEY UPDATE amount = amount + ?";
                } else if (format == 2) {
                    query = "INSERT INTO " + this.tablePrefix + table + " (uuid, world, amount, value)" + "VALUES (?, ?, ?, ?) " + "ON DUPLICATE KEY UPDATE amount = amount + ?";
                } else if (format == 3) {
                    query = "INSERT INTO " + this.tablePrefix + table + " (uuid, world, amount, value, name)" + "VALUES (?, ?, ?, ?, ?) " + "ON DUPLICATE KEY UPDATE amount = amount + ?";
                } else if (format == 4) {
                    query = "INSERT INTO " + this.tablePrefix + table + " (uuid, name, ip)" + "VALUES (?, ?, ?) " + "ON DUPLICATE KEY UPDATE name = ?, ip = ?";
                }
                pstmt = conn.prepareStatement(query);
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    pstmt.setString(1, ((StatKey)entry2.getKey()).uuid.toString());
                    if (format == 1) {
                        pstmt.setString(2, ((StatKey)entry2.getKey()).world);
                        pstmt.setInt(3, (Integer)entry2.getValue());
                        pstmt.setInt(4, (Integer)entry2.getValue());
                    } else if (format == 2) {
                        pstmt.setString(2, ((StatKey)entry2.getKey()).world);
                        pstmt.setInt(3, (Integer)entry2.getValue());
                        pstmt.setString(4, ((StatKey)entry2.getKey()).value);
                        pstmt.setInt(5, (Integer)entry2.getValue());
                    } else if (format == 3) {
                        String itemName = ((StatKey)entry2.getKey()).name;
                        if (itemName.length() > 100) {
                            itemName = itemName.substring(0, 100);
                        }
                        pstmt.setString(2, ((StatKey)entry2.getKey()).world);
                        pstmt.setInt(3, (Integer)entry2.getValue());
                        pstmt.setString(4, ((StatKey)entry2.getKey()).value);
                        pstmt.setString(5, itemName);
                        pstmt.setInt(6, (Integer)entry2.getValue());
                    } else if (format == 4) {
                        pstmt.setString(2, ((StatKey)entry2.getKey()).value);
                        pstmt.setString(3, ((StatKey)entry2.getKey()).extra);
                        pstmt.setString(4, ((StatKey)entry2.getKey()).value);
                        pstmt.setString(5, ((StatKey)entry2.getKey()).extra);
                    }
                    int n2 = pstmt.executeUpdate();
                }
            }
            if (this.plugin.tracker != null) {
                query = "INSERT INTO " + this.tablePrefix + "pvp_streak (uuid, value) " + "VALUES (?, ?) " + "ON DUPLICATE KEY UPDATE value = ?";
                pstmt = conn.prepareStatement(query);
                for (Map.Entry<Object, Object> entry : this.plugin.tracker.getKillStreaks().entrySet()) {
                    pstmt.setString(1, ((UUID)entry.getKey()).toString());
                    pstmt.setInt(2, (Integer)entry.getValue());
                    pstmt.setInt(3, (Integer)entry.getValue());
                    int n3 = pstmt.executeUpdate();
                }
            }
            pstmt = conn.prepareStatement("INSERT INTO " + this.tablePrefix + "maxes (uuid, value, amount) " + "VALUES (?, ?, ?) " + "ON DUPLICATE KEY UPDATE amount = GREATEST(?, amount) ");
            for (StatUpdate statUpdate : maxStatsCopy) {
                pstmt.setString(1, statUpdate.uuid.toString());
                pstmt.setString(2, statUpdate.table);
                pstmt.setInt(3, statUpdate.amount);
                pstmt.setInt(4, statUpdate.amount);
                int n4 = pstmt.executeUpdate();
            }
            pstmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            Bukkit.getLogger().severe("Query error for " + this.plugin.getName() + ": " + query);
            Bukkit.getLogger().severe("Error " + ex.getErrorCode() + ": " + ex.getMessage());
        }
    }

    public int getPvPStreak(UUID player) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String query = "";
        int streak = 0;
        try {
            conn = DriverManager.getConnection(this.database);
            pstmt = conn.prepareStatement("SELECT value FROM " + this.tablePrefix + "pvp_streak " + "WHERE uuid = ? ");
            pstmt.setString(1, player.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                streak = rs.getInt("value");
            }
            rs.close();
        }
        catch (SQLException ex) {
            Bukkit.getLogger().severe("Query error for " + this.plugin.getName() + ": " + query);
            Bukkit.getLogger().severe("Error " + ex.getErrorCode() + ": " + ex.getMessage());
        }
        return streak;
    }
}

