/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats;

import com.interordi.iobattlestats.IOBattleStats;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayersTracking {
    IOBattleStats plugin;
    private Map<UUID, Location> locations = new HashMap<UUID, Location>();
    private Map<UUID, Integer> pvpStreaks = new HashMap<UUID, Integer>();

    PlayersTracking(IOBattleStats plugin) {
        this.plugin = plugin;
    }

    public void add(Player player) {
        this.locations.put(player.getUniqueId(), null);
    }

    public void remove(Player player) {
        this.locations.remove(player.getUniqueId());
    }

    public Location getLastPosition(Player player) {
        return this.locations.get(player.getUniqueId());
    }

    public void setPosition(Player player, Location pos) {
        this.locations.put(player.getUniqueId(), pos);
    }

    public void registerKill(Player player) {
        if (this.pvpStreaks.containsKey(player.getUniqueId())) {
            int kills = this.pvpStreaks.get(player.getUniqueId());
            this.pvpStreaks.put(player.getUniqueId(), kills + 1);
        } else {
            this.pvpStreaks.put(player.getUniqueId(), 1);
        }
    }

    public void resetKills(Player player) {
        this.pvpStreaks.put(player.getUniqueId(), 0);
    }

    public Map<UUID, Integer> getKillStreaks() {
        return this.pvpStreaks;
    }

    public void setKillStreak(UUID player, int amount) {
        this.pvpStreaks.put(player, amount);
    }
}

