/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats.listeners;

import com.interordi.iobattlestats.IOBattleStats;
import com.interordi.iobattlestats.utilities.Heads;
import com.interordi.iobattlestats.utilities.Utilities;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DeathListener
implements Listener {
    IOBattleStats plugin;

    public DeathListener(IOBattleStats plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        String killerName = "";
        String killedName = "";
        boolean playerSource = false;
        boolean playerTarget = false;
        if (event.getEntity().getLastDamageCause() == null) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            Player killer = event.getEntity().getKiller();
            LivingEntity killed = event.getEntity();
            if (killer != null) {
                String cause = event.getEntity().getLastDamageCause().getCause().toString();
                String itemName = "";
                ItemStack held = killer.getInventory().getItemInMainHand();
                if (held != null && held.getItemMeta() != null && held.getType() != Material.AIR) {
                    cause = held.getType().toString();
                    if (held.getItemMeta() != null) {
                        itemName = held.getItemMeta().getDisplayName();
                    }
                } else {
                    held = killer.getInventory().getItemInOffHand();
                    if (held != null && held.getItemMeta() != null) {
                        cause = held.getType().toString();
                        if (held.getItemMeta() != null) {
                            itemName = held.getItemMeta().getDisplayName();
                        }
                    }
                }
                killerName = killer.getUniqueId().toString();
                killedName = killed.getType().toString();
                playerSource = true;
                if (killer.hasPermission("iobattlestats.track")) {
                    this.plugin.data.recordDeath(killerName, killedName, killed.getWorld().getName(), cause, itemName, playerSource, playerTarget);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        Player killed = event.getEntity().getPlayer();
        String itemName = "";
        String killerName = "";
        String killedName = killed.getUniqueId().toString();
        String cause = "";
        boolean playerSource = false;
        boolean playerTarget = true;
        EntityDamageEvent lastDamage = event.getEntity().getLastDamageCause();
        if (killer != null) {
            ItemStack head = Heads.getCustomSkull((OfflinePlayer)killed);
            event.getEntity().getWorld().dropItemNaturally(killed.getLocation(), head);
            ItemStack held = killer.getInventory().getItemInMainHand();
            if (held != null && held.getItemMeta() != null && held.getType() != Material.AIR) {
                cause = held.getType().toString();
                if (held.getItemMeta() != null && held.getItemMeta().hasDisplayName()) {
                    itemName = held.getItemMeta().getDisplayName();
                }
            } else {
                held = killer.getInventory().getItemInOffHand();
                if (held != null) {
                    cause = held.getType().toString();
                    if (held.getItemMeta() != null && held.getItemMeta().hasDisplayName()) {
                        itemName = held.getItemMeta().getDisplayName();
                    }
                }
            }
            this.plugin.tracker.registerKill(killer);
            this.plugin.tracker.resetKills(killed);
            killerName = killer.getUniqueId().toString();
            playerSource = true;
            playerTarget = true;
        } else {
            EntityDamageByEntityEvent nEvent;
            playerSource = false;
            if (lastDamage != null && lastDamage instanceof EntityDamageByEntityEvent && (nEvent = (EntityDamageByEntityEvent)lastDamage).getDamager() != null) {
                if (nEvent.getDamager() instanceof Projectile) {
                    Projectile projectile = (Projectile)nEvent.getDamager();
                    Entity temp = (Entity)projectile.getShooter();
                    killerName = temp.getType().toString();
                    cause = Utilities.getDamagerType(nEvent.getDamager());
                } else {
                    killerName = nEvent.getDamager().getType().toString();
                }
            }
        }
        if (cause == null || cause.equals("")) {
            cause = lastDamage != null ? lastDamage.getCause().toString() : "Natural causes";
        }
        if (playerSource && killer.hasPermission("iobattlestats.track") || playerTarget && killed.hasPermission("iobattlestats.track")) {
            this.plugin.data.recordDeath(killerName, killedName, killed.getWorld().getName(), cause, itemName, playerSource, playerTarget);
        }
    }
}

