/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats.listeners;

import com.interordi.iobattlestats.IOBattleStats;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LoginListener
implements Listener {
    private IOBattleStats plugin;
    private boolean enable;

    public LoginListener(IOBattleStats plugin, boolean enable) {
        this.plugin = plugin;
        this.enable = enable;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerLogin(PlayerJoinEvent event) {
        this.plugin.addPlayer(event.getPlayer());
        String ip = event.getPlayer().getAddress().getAddress().toString();
        if (ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        this.plugin.data.recordPlayer(event.getPlayer().getUniqueId(), event.getPlayer().getName(), ip);
        if (!this.enable || !event.getPlayer().hasPermission("iobattlestats.track")) {
            return;
        }
        this.plugin.data.recordBasicStat("joins", event.getPlayer().getUniqueId(), 1, event.getPlayer().getWorld().getName());
        final UUID uuid = event.getPlayer().getUniqueId();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int streak = ((LoginListener)LoginListener.this).plugin.data.getPvPStreak(uuid);
                ((LoginListener)LoginListener.this).plugin.tracker.setKillStreak(uuid, streak);
            }
        });
    }

    @EventHandler
    public void onPlayerLogout(PlayerQuitEvent event) {
        this.plugin.removePlayer(event.getPlayer());
    }
}

