/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.github.litermc.vtil.VtilListeners;
import com.github.litermc.vtil.VtilRegistry;
import com.github.litermc.vtil.block.BlockCapabilityProviders;
import com.github.litermc.vtil.command.VtilCommands;
import com.github.litermc.vtil.config.ConfigSpec;
import com.github.litermc.vtil.platform.ForgeConfigFile;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="vtil")
@Mod.EventBusSubscriber
public class ModEntry {
    public ModEntry() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modBus = context.getModEventBus();
        VtilRegistry.register();
        BlockCapabilityProviders.register();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)((ForgeConfigFile)ConfigSpec.serverSpec).spec());
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            VtilListeners.onServerLevelLoad(level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            VtilListeners.onServerLevelUnload(level);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                VtilListeners.preServerTick(event.getServer());
                break;
            }
            case END: {
                VtilListeners.postServerTick(event.getServer());
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        VtilCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        this.syncConfig(event.getConfig());
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        this.syncConfig(event.getConfig());
    }

    private void syncConfig(ModConfig config) {
        Path path;
        if (!config.getModId().equals("vtil")) {
            return;
        }
        CommentedConfig commentedConfig = config.getConfigData();
        if (commentedConfig instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)commentedConfig;
            v0 = fileConfig.getNioPath();
        } else {
            v0 = path = null;
        }
        if (config.getType() == ModConfig.Type.SERVER && ((ForgeConfigFile)ConfigSpec.serverSpec).spec().isLoaded()) {
            ConfigSpec.syncServer(path);
        } else if (config.getType() == ModConfig.Type.CLIENT) {
            ConfigSpec.syncClient(path);
        }
    }
}

