/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.assemble;

import com.github.litermc.vtil.api.assemble.IMoveable;
import com.github.litermc.vtil.api.assemble.MoveApi;
import com.github.litermc.vtil.compat.CompatMods;
import com.github.litermc.vtil.util.Pair;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class AssembleApi {
    private AssembleApi() {
    }

    public static ServerShip createShip(ServerLevel level, Set<BlockPos> blocks, final ServerShip rootShip) {
        Vec3 pos;
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
        String levelId = VSGameUtilsKt.getDimensionId((Level)level);
        AABBd blocksBox = new AABBd();
        BlockPos pos2 = blocks.iterator().next();
        blocksBox.setMin((double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_()).setMax((double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_());
        for (BlockPos pos3 : blocks) {
            blocksBox.union((double)pos3.m_123341_(), (double)pos3.m_123342_(), (double)pos3.m_123343_());
        }
        blocksBox.maxX += 1.0;
        blocksBox.maxY += 1.0;
        blocksBox.maxZ += 1.0;
        Vector3i worldCenter = new Vector3i((Vector3dc)blocksBox.center(new Vector3d()), 0);
        final ServerShip ship = shipWorld.createNewShipAtBlock((Vector3ic)worldCenter, false, 1.0, levelId);
        Vector3i shipCenter = ship.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i());
        Vector3i offset = shipCenter.sub((Vector3ic)worldCenter, new Vector3i());
        ArrayList<Pair<BlockPos, BlockState>> blockStates = new ArrayList<Pair<BlockPos, BlockState>>(blocks.size());
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : level.m_45933_(null, new AABB(blocksBox.minX - 1.0, blocksBox.minY - 1.0, blocksBox.minZ - 1.0, blocksBox.maxX + 2.0, blocksBox.maxY + 2.0, blocksBox.maxZ + 2.0))) {
            if (entity instanceof HangingEntity) {
                HangingEntity he = (HangingEntity)entity;
                BlockPos hanging = he.m_31748_().m_121945_(he.m_6350_().m_122424_());
                if (!blocks.contains(hanging)) continue;
                entities.add(entity);
                continue;
            }
            if (!CompatMods.CREATE.isLoaded()) continue;
            if (entity instanceof SeatEntity) {
                SeatEntity seat = (SeatEntity)entity;
                if (!blocks.contains(seat.m_20183_())) continue;
                entities.add(entity);
                continue;
            }
            if (!(entity instanceof SuperGlueEntity)) continue;
            SuperGlueEntity glue = (SuperGlueEntity)entity;
            AABB bb = glue.m_20191_();
            if (!AssembleApi.streamBlocksInAABB(bb).anyMatch(blocks::contains)) continue;
            entities.add(entity);
        }
        for (BlockPos blockPos : blocks) {
            BlockPos target = blockPos.m_7918_(offset.x, offset.y, offset.z);
            BlockState oldState = level.m_8055_(blockPos);
            boolean wasAir = oldState.m_60795_();
            BlockEntity be = level.m_7702_(blockPos);
            IMoveable<?> moveableOld = MoveApi.getMover(be);
            if (moveableOld == null) {
                moveableOld = MoveApi.getMover(oldState.m_60734_());
            }
            if (moveableOld != null) {
                moveableOld.beforeSaveForMove(level, blockPos, target);
            }
            BlockState state = level.m_8055_(blockPos);
            if (wasAir && moveableOld == null && state == oldState) continue;
            blockStates.add(new Pair<BlockPos, BlockState>(blockPos.m_7949_(), state));
            CompoundTag nbt = level.m_46745_(blockPos).m_8051_(blockPos);
            if (nbt != null) {
                BlockPos targetPos = blockPos.m_7918_(offset.x, offset.y, offset.z);
                nbt.m_128405_("x", targetPos.m_123341_());
                nbt.m_128405_("y", targetPos.m_123342_());
                nbt.m_128405_("z", targetPos.m_123343_());
                level.m_46745_(targetPos).m_5604_(nbt);
            }
            Clearable.m_18908_((Object)be);
            Object moveData = moveableOld != null ? (Object)moveableOld.beforeMove(level, blockPos, target) : null;
            level.m_7731_(target, state, 82);
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 82);
            IMoveable<?> moveableNew = MoveApi.getMover(level.m_7702_(target));
            if (moveableNew == null) {
                moveableNew = MoveApi.getMover(state.m_60734_());
            }
            if (moveableNew == null) continue;
            moveableNew.afterMove(level, blockPos, target, moveData);
        }
        if (blockStates.isEmpty()) {
            shipWorld.deleteShip(ship);
            return null;
        }
        for (Entity entity : entities) {
            pos = entity.m_20182_();
            entity.m_6034_(pos.f_82479_ + (double)offset.x, pos.f_82480_ + (double)offset.y, pos.f_82481_ + (double)offset.z);
        }
        for (Pair pair : blockStates) {
            pos = (BlockPos)pair.left();
            Block block = ((BlockState)pair.right()).m_60734_();
            level.m_6289_((BlockPos)pos, block);
            level.m_6289_(pos.m_7918_(offset.x, offset.y, offset.z), block);
        }
        AABBic box = ship.getShipAABB();
        final Vector3d vector3d = ship.getTransform().getPositionInWorld().add(ship.getInertiaData().getCenterOfMassInShip(), new Vector3d()).sub((double)shipCenter.x, (double)shipCenter.y, (double)shipCenter.z);
        final Vector3d position = new Vector3d((Vector3dc)vector3d);
        final Quaterniond rotation = new Quaterniond();
        final Vector3d velocity = new Vector3d();
        final Vector3d omega = new Vector3d();
        final Vector3d scaling = new Vector3d(1.0);
        double scale = 1.0;
        if (rootShip != null) {
            ShipTransform selfTransform = rootShip.getTransform();
            selfTransform.getShipToWorld().transformPosition(position);
            rotation.set(selfTransform.getShipToWorldRotation());
            velocity.set(rootShip.getVelocity());
            omega.set(rootShip.getOmega());
            scaling.set(selfTransform.getShipToWorldScaling());
            scale = Math.sqrt(scaling.lengthSquared() / 3.0);
        }
        shipWorld.teleportShip(ship, (ShipTeleportData)new ShipTeleportDataImpl((Vector3dc)position, (Quaterniondc)rotation, (Vector3dc)velocity, (Vector3dc)omega, levelId, Double.valueOf(scale)));
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform transform, ShipTransform nextTransform) {
                    if (!transform.getPositionInWorld().equals(nextTransform.getPositionInWorld()) || !transform.getShipToWorldRotation().equals(nextTransform.getShipToWorldRotation())) {
                        ship.setTransformProvider(null);
                        return null;
                    }
                    if (ship.getVelocity().lengthSquared() == 0.0 && ship.getOmega().lengthSquared() == 0.0) {
                        if (rootShip != null) {
                            ShipTransform selfTransform2 = rootShip.getTransform();
                            selfTransform2.getShipToWorld().transformPosition((Vector3dc)vector3d, position);
                            rotation.set(selfTransform2.getShipToWorldRotation());
                            velocity.set(rootShip.getVelocity());
                            omega.set(rootShip.getOmega());
                            scaling.set(selfTransform2.getShipToWorldScaling());
                        }
                        return new ServerShipTransformProvider.NextTransformAndVelocityData((ShipTransform)new ShipTransformImpl((Vector3dc)position, nextTransform.getPositionInShip(), (Quaterniondc)rotation, (Vector3dc)scaling), (Vector3dc)velocity, (Vector3dc)omega);
                    }
                    return null;
                }
            });
        }
        return ship;
    }

    private static Stream<BlockPos> streamBlocksInAABB(AABB box) {
        int minX = (int)Math.round(box.f_82288_);
        int maxX = (int)Math.round(box.f_82291_);
        int minY = (int)Math.round(box.f_82289_);
        int maxY = (int)Math.round(box.f_82292_);
        int minZ = (int)Math.round(box.f_82290_);
        int maxZ = (int)Math.round(box.f_82293_);
        int widthX = maxX - minX;
        int widthY = maxY - minY;
        int widthZ = maxZ - minZ;
        return IntStream.range(0, widthX * widthY * widthZ).mapToObj(i -> {
            int x = i % widthX + minX;
            int z = (i /= widthX) % widthZ + minZ;
            int y = (i /= widthZ) + minY;
            return new BlockPos(x, y, z);
        });
    }
}

