/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.connectivity;

import com.github.litermc.vtil.api.connectivity.IBlockAnchor;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public final class BlockConnectivityApi {
    private BlockConnectivityApi() {
    }

    public static final boolean isAir(BlockState state) {
        FluidState fluidState;
        if (state.m_60795_()) {
            return true;
        }
        return state.m_60734_() instanceof LiquidBlock && ((fluidState = state.m_60819_()).m_76178_() || !fluidState.m_76170_());
    }

    public static final void getConnectableBlocks(LevelAccessor level, BlockPos pos, Collection<BlockPos> result) {
        BlockState state = level.m_8055_(pos);
        if (BlockConnectivityApi.isAir(state)) {
            return;
        }
        BlockConnectivityApi.getConnectableBlocks(level, pos, state, result);
    }

    public static final void getConnectableBlocks(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> result) {
        IBlockAnchor anchor = (IBlockAnchor)state.m_60734_();
        anchor.getConnectableBlocks(level, pos, state, result);
    }

    public static boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (oldState == newState) {
            return true;
        }
        boolean wasAir = BlockConnectivityApi.isAir(oldState);
        if (wasAir != BlockConnectivityApi.isAir(newState)) {
            return true;
        }
        if (!wasAir) {
            return true;
        }
        IBlockAnchor anchor = (IBlockAnchor)newState.m_60734_();
        return anchor.willConnectivityChange(level, pos, oldState, newState);
    }
}

