/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.assemble;

import com.github.litermc.vtil.api.assemble.IMoveable;
import com.github.litermc.vtil.api.assemble.MoveApi;
import com.github.litermc.vtil.compat.CompatMods;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class AssembleApi {
    private AssembleApi() {
    }

    public static ServerShip createShip(ServerLevel level, Set<BlockPos> blocks, final ServerShip rootShip) {
        BlockPos targetPos;
        BlockState state;
        BlockState AIR = Blocks.f_50016_.m_49966_();
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
        String levelId = VSGameUtilsKt.getDimensionId((Level)level);
        AABBd blocksBox = new AABBd();
        BlockPos pos = blocks.iterator().next();
        blocksBox.setMin((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).setMax((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        for (BlockPos pos2 : blocks) {
            blocksBox.union((double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_());
        }
        blocksBox.maxX += 1.0;
        blocksBox.maxY += 1.0;
        blocksBox.maxZ += 1.0;
        Vector3i worldCenter = new Vector3i((Vector3dc)blocksBox.center(new Vector3d()), 0);
        final ServerShip ship = shipWorld.createNewShipAtBlock((Vector3ic)worldCenter, false, 1.0, levelId);
        Vector3i shipCenter = ship.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i());
        Vector3i offset = shipCenter.sub((Vector3ic)worldCenter, new Vector3i());
        HashMap<BlockPos, BlockState> blockStates = new HashMap<BlockPos, BlockState>(blocks.size());
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : level.m_45933_(null, new AABB(blocksBox.minX - 1.0, blocksBox.minY - 1.0, blocksBox.minZ - 1.0, blocksBox.maxX + 2.0, blocksBox.maxY + 2.0, blocksBox.maxZ + 2.0))) {
            if (entity instanceof HangingEntity) {
                HangingEntity he = (HangingEntity)entity;
                BlockPos hanging = he.m_31748_().m_121945_(he.m_6350_().m_122424_());
                if (!blocks.contains(hanging)) continue;
                entities.add(entity);
                continue;
            }
            if (!CompatMods.CREATE.isLoaded()) continue;
            if (entity instanceof SeatEntity) {
                SeatEntity seat = (SeatEntity)entity;
                if (!blocks.contains(seat.m_20183_())) continue;
                entities.add(entity);
                continue;
            }
            if (!(entity instanceof SuperGlueEntity)) continue;
            SuperGlueEntity glue = (SuperGlueEntity)entity;
            AABB bb = glue.m_20191_();
            if (!AssembleApi.streamBlocksInAABB(bb).anyMatch(blocks::contains)) continue;
            entities.add(entity);
        }
        for (BlockPos pos3 : blocks) {
            BlockPos target = pos3.m_7918_(offset.x, offset.y, offset.z);
            BlockState oldState = level.m_8055_(pos3);
            boolean wasAir = oldState.m_60795_();
            BlockEntity be = level.m_7702_(pos3);
            IMoveable<?> moveableOld = MoveApi.getMover(be);
            if (moveableOld == null) {
                moveableOld = MoveApi.getMover(oldState.m_60734_());
            }
            if (moveableOld != null) {
                moveableOld.beforeSaveForMove(level, pos3, target);
            }
            state = level.m_8055_(pos3);
            if (wasAir && moveableOld == null && state == oldState) continue;
            blockStates.put(pos3.m_7949_(), state);
            CompoundTag nbt = level.m_46745_(pos3).m_8051_(pos3);
            if (nbt != null) {
                targetPos = pos3.m_7918_(offset.x, offset.y, offset.z);
                nbt.m_128405_("x", targetPos.m_123341_());
                nbt.m_128405_("y", targetPos.m_123342_());
                nbt.m_128405_("z", targetPos.m_123343_());
                level.m_46745_(targetPos).m_5604_(nbt);
            }
            Clearable.m_18908_((Object)be);
            Object moveData = moveableOld != null ? (Object)moveableOld.beforeMove(level, pos3, target) : null;
            level.m_7731_(pos3, AIR, 82);
            level.m_7731_(target, state, 82);
            Direction[] moveableNew = MoveApi.getMover(level.m_7702_(target));
            if (moveableNew == null) {
                moveableNew = MoveApi.getMover(state.m_60734_());
            }
            if (moveableNew == null) continue;
            moveableNew.afterMove(level, pos3, target, moveData);
        }
        if (blockStates.isEmpty()) {
            shipWorld.deleteShip(ship);
            return null;
        }
        for (Entity entity : entities) {
            Vec3 pos4 = entity.m_20182_();
            entity.m_6034_(pos4.f_82479_ + (double)offset.x, pos4.f_82480_ + (double)offset.y, pos4.f_82481_ + (double)offset.z);
        }
        int MAX_BLOCK_UPDATE = 511;
        int BLOCK_UPDATE_FLAGS = 65;
        DenseBlockPosSet tickedAirs = new DenseBlockPosSet();
        BlockPos.MutableBlockPos airPos = new BlockPos.MutableBlockPos();
        for (Map.Entry entry : blockStates.entrySet()) {
            BlockPos pos5 = (BlockPos)entry.getKey();
            state = (BlockState)entry.getValue();
            Block block = state.m_60734_();
            targetPos = pos5.m_7918_(offset.x, offset.y, offset.z);
            level.m_6289_(pos5, block);
            state.m_60762_((LevelAccessor)level, pos5, 65, 511);
            AIR.m_60705_((LevelAccessor)level, pos5, 65, 511);
            level.m_6559_(pos5, state, AIR);
            level.m_6289_(targetPos, block);
            state.m_60705_((LevelAccessor)level, targetPos, 65, 511);
            state.m_60762_((LevelAccessor)level, targetPos, 65, 511);
            level.m_6559_(targetPos, AIR, state);
            for (Direction dir : Direction.values()) {
                airPos.m_122159_((Vec3i)targetPos, dir);
                if (blockStates.containsKey(airPos) || !tickedAirs.add(airPos.m_123341_(), airPos.m_123342_(), airPos.m_123343_())) continue;
                AIR.m_60705_((LevelAccessor)level, (BlockPos)airPos, 65, 511);
            }
        }
        final Vector3d absPosition = ship.getTransform().getPositionInWorld().add(ship.getInertiaData().getCenterOfMassInShip(), new Vector3d()).sub((double)shipCenter.x, (double)shipCenter.y, (double)shipCenter.z);
        final Vector3d position = new Vector3d((Vector3dc)absPosition);
        final Quaterniond rotation = new Quaterniond();
        final Vector3d velocity = new Vector3d();
        final Vector3d omega = new Vector3d();
        final Vector3d scaling = new Vector3d(1.0);
        double scale = 1.0;
        if (rootShip != null) {
            ShipTransform selfTransform = rootShip.getTransform();
            selfTransform.getShipToWorld().transformPosition(position);
            rotation.set(selfTransform.getShipToWorldRotation());
            velocity.set(rootShip.getVelocity());
            omega.set(rootShip.getOmega());
            scaling.set(selfTransform.getShipToWorldScaling());
            scale = Math.sqrt(scaling.lengthSquared() / 3.0);
        }
        shipWorld.teleportShip(ship, (ShipTeleportData)new ShipTeleportDataImpl((Vector3dc)position, (Quaterniondc)rotation, (Vector3dc)velocity, (Vector3dc)omega, levelId, Double.valueOf(scale)));
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            final ServerShipTransformProvider oldProvider = ship.getTransformProvider();
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform transform, ShipTransform nextTransform) {
                    if (!transform.getPositionInWorld().equals(nextTransform.getPositionInWorld()) || !transform.getShipToWorldRotation().equals(nextTransform.getShipToWorldRotation())) {
                        ship.setTransformProvider(oldProvider);
                        return null;
                    }
                    if (rootShip != null) {
                        ShipTransform selfTransform2 = rootShip.getTransform();
                        selfTransform2.getShipToWorld().transformPosition((Vector3dc)absPosition, position);
                        rotation.set(selfTransform2.getShipToWorldRotation());
                        velocity.set(rootShip.getVelocity());
                        omega.set(rootShip.getOmega());
                        scaling.set(selfTransform2.getShipToWorldScaling());
                    }
                    return new ServerShipTransformProvider.NextTransformAndVelocityData((ShipTransform)new ShipTransformImpl((Vector3dc)position, nextTransform.getPositionInShip(), (Quaterniondc)rotation, (Vector3dc)scaling), (Vector3dc)velocity, (Vector3dc)omega);
                }
            });
        }
        return ship;
    }

    private static Stream<BlockPos> streamBlocksInAABB(AABB box) {
        int minX = (int)Math.round(box.f_82288_);
        int maxX = (int)Math.round(box.f_82291_);
        int minY = (int)Math.round(box.f_82289_);
        int maxY = (int)Math.round(box.f_82292_);
        int minZ = (int)Math.round(box.f_82290_);
        int maxZ = (int)Math.round(box.f_82293_);
        int widthX = maxX - minX;
        int widthY = maxY - minY;
        int widthZ = maxZ - minZ;
        return IntStream.range(0, widthX * widthY * widthZ).mapToObj(i -> {
            int x = i % widthX + minX;
            int z = (i /= widthX) % widthZ + minZ;
            int y = (i /= widthZ) + minY;
            return new BlockPos(x, y, z);
        });
    }
}

