/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.assemble;

import com.github.litermc.vtil.api.assemble.IMoveable;
import com.github.litermc.vtil.compat.CompatMods;
import com.github.litermc.vtil.compat.create.MoveableIControlContraption;
import com.simibubi.create.content.contraptions.IControlContraption;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class MoveApi {
    private static final Map<Class<?>, IMoveable<?>> DEFAULT_MOVERS = new HashMap();

    private MoveApi() {
    }

    public static IMoveable<?> registerDefaultMover(Class<?> clazz, IMoveable<?> mover) {
        if (mover == null) {
            return DEFAULT_MOVERS.remove(clazz);
        }
        return DEFAULT_MOVERS.put(clazz, mover);
    }

    public static IMoveable<?> getMover(Object instance) {
        Class<?> clazz;
        if (instance == null) {
            return null;
        }
        if (instance instanceof IMoveable) {
            IMoveable mover = (IMoveable)instance;
            return mover;
        }
        for (clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            IMoveable<?> mover = DEFAULT_MOVERS.get(clazz);
            if (mover == null) continue;
            return mover;
        }
        for (clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Class intf : Stream.of(clazz.getInterfaces()).flatMap(MoveApi::streamClassAnsSubInterfaces)::iterator) {
                IMoveable<?> mover = DEFAULT_MOVERS.get(intf);
                if (mover == null) continue;
                return mover;
            }
        }
        return null;
    }

    public static void registerDefaultMovers() {
        if (CompatMods.CREATE.isLoaded()) {
            MoveApi.registerDefaultMover(IControlContraption.class, MoveableIControlContraption.INSTANCE);
        }
    }

    private static Stream<Class<?>> streamClassAnsSubInterfaces(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), Stream.of(clazz.getInterfaces()).flatMap(MoveApi::streamClassAnsSubInterfaces));
    }
}

