/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.connectivity;

import com.github.litermc.vtil.api.connectivity.IBlockAnchor;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public final class BlockConnectivityApi {
    private BlockConnectivityApi() {
    }

    public static final boolean isAir(BlockState state) {
        FluidState fluidState;
        if (state.m_60795_()) {
            return true;
        }
        return state.m_60734_() instanceof LiquidBlock && ((fluidState = state.m_60819_()).m_76178_() || !fluidState.m_76170_());
    }

    public static final boolean isFluidLogged(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false;
    }

    public static final void getPossibleConnectableBlocks(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> result) {
        if (BlockConnectivityApi.isFluidLogged(state)) {
            for (Direction dir : Direction.values()) {
                result.add(pos.m_121945_(dir));
            }
            return;
        }
        IBlockAnchor anchor = (IBlockAnchor)state.m_60734_();
        anchor.getConnectableBlocks(level, pos, state, result);
    }

    public static final void getConnectableBlocks(LevelAccessor level, BlockPos pos, Collection<BlockPos> result) {
        BlockState state = level.m_8055_(pos);
        if (BlockConnectivityApi.isAir(state)) {
            return;
        }
        BlockConnectivityApi.getConnectableBlocks(level, pos, state, result);
    }

    public static final void getConnectableBlocks(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> result) {
        BlockConnectivityApi.getPossibleConnectableBlocks(level, pos, state, result);
        result.removeIf(p -> {
            BlockState s = level.m_8055_(p);
            return BlockConnectivityApi.isAir(s) || !BlockConnectivityApi.isBlockConnectable0(level, p, s, pos, state);
        });
    }

    public static final boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockPos targetPos) {
        BlockState state = level.m_8055_(pos);
        if (BlockConnectivityApi.isAir(state)) {
            return false;
        }
        BlockState targetState = level.m_8055_(targetPos);
        if (BlockConnectivityApi.isAir(targetState)) {
            return false;
        }
        return BlockConnectivityApi.isBlockConnectable(level, pos, state, targetPos, targetState);
    }

    public static final boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        return BlockConnectivityApi.isBlockConnectable0(level, pos, state, targetPos, targetState) && BlockConnectivityApi.isBlockConnectable0(level, targetPos, targetState, pos, state);
    }

    private static final boolean isBlockConnectable0(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        return BlockConnectivityApi.isFluidLogged(state) || ((IBlockAnchor)state.m_60734_()).isBlockConnectable(level, pos, state, targetPos, targetState);
    }

    public static boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (oldState == newState) {
            return false;
        }
        if (BlockConnectivityApi.isFluidLogged(oldState) && BlockConnectivityApi.isFluidLogged(newState)) {
            return false;
        }
        boolean wasAir = BlockConnectivityApi.isAir(oldState);
        if (wasAir != BlockConnectivityApi.isAir(newState)) {
            return true;
        }
        if (wasAir) {
            return false;
        }
        IBlockAnchor anchor = (IBlockAnchor)newState.m_60734_();
        return anchor.willConnectivityChange(level, pos, oldState, newState);
    }
}

