/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.teleport;

import com.github.litermc.vtil.api.entity.ISpecialTeleportLogicEntity;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class TeleportUtil {
    public static void teleportShip(LoadedServerShip ship, TeleportData data) {
        ServerLevel level = data.level();
        String dimension = VSGameUtilsKt.getDimensionId((Level)level);
        final ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
        final long id = ship.getId();
        Vector3dc newPos = data.newPos();
        Quaterniondc rotation = data.rotation();
        final Vector3dc velocity = data.velocity();
        final Vector3dc omega = data.omega();
        ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl(newPos, rotation, velocity, omega, dimension, null);
        world.teleportShip((ServerShip)ship, (ShipTeleportData)teleportData);
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            final ServerShipTransformProvider oldProvider = ship.getTransformProvider();
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform prevTransform, ShipTransform transform) {
                    LoadedServerShip ship2 = (LoadedServerShip)world.getLoadedShips().getById(id);
                    if (!prevTransform.getPositionInWorld().equals(transform.getPositionInWorld()) || !prevTransform.getShipToWorldRotation().equals(transform.getShipToWorldRotation())) {
                        ship2.setTransformProvider(oldProvider);
                        return null;
                    }
                    if (ship2.getVelocity().lengthSquared() == 0.0 && ship2.getOmega().lengthSquared() == 0.0) {
                        return new ServerShipTransformProvider.NextTransformAndVelocityData(transform, velocity, omega);
                    }
                    return null;
                }
            });
        }
    }

    public static <T extends Entity> T teleportEntity(T entity, ServerLevel newLevel, Vec3 newPos) {
        Object newEntity;
        ISpecialTeleportLogicEntity specialEntity;
        Vec3 oldPos = entity.m_20182_();
        List<Entity> passengers = List.copyOf(entity.m_20197_());
        if (entity instanceof ISpecialTeleportLogicEntity) {
            ISpecialTeleportLogicEntity specialEntity2 = (ISpecialTeleportLogicEntity)entity;
            specialEntity2.beforeDimentionalTeleport();
        }
        for (Entity p : passengers) {
            if (!(p instanceof ISpecialTeleportLogicEntity)) continue;
            specialEntity = (ISpecialTeleportLogicEntity)p;
            specialEntity.beforeDimentionalTeleport();
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_8999_(newLevel, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, player.m_146908_(), player.m_146909_());
            newEntity = entity;
        } else {
            newEntity = entity.m_6095_().m_20615_((Level)newLevel);
            if (newEntity == null) {
                if (entity instanceof ISpecialTeleportLogicEntity) {
                    specialEntity = (ISpecialTeleportLogicEntity)entity;
                    specialEntity.afterDimentionalTeleport(null);
                }
                return null;
            }
            entity.m_20153_();
            newEntity.m_20361_(entity);
            newEntity.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, newEntity.m_146908_(), newEntity.m_146909_());
            newEntity.m_5616_(entity.m_6080_());
            newEntity.m_5618_(entity.m_213816_());
            newLevel.m_143334_(newEntity);
            entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        for (Entity p : passengers) {
            Entity newPassenger = TeleportUtil.teleportEntity(p, newLevel, p.m_20182_().m_82546_(oldPos).m_82549_(newPos));
            if (newPassenger == null) continue;
            newPassenger.m_7998_(newEntity, true);
        }
        if (newEntity instanceof ISpecialTeleportLogicEntity) {
            ISpecialTeleportLogicEntity specialEntity3 = (ISpecialTeleportLogicEntity)newEntity;
            specialEntity3.afterDimentionalTeleport((ISpecialTeleportLogicEntity)entity);
        }
        return (T)newEntity;
    }

    public record TeleportData(ServerLevel level, Vector3dc newPos, Quaterniondc rotation, Vector3dc velocity, Vector3dc omega) {
    }
}

