/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.block;

import com.github.litermc.vtil.api.assemble.AssembleApi;
import com.github.litermc.vtil.api.connectivity.BlockConnectivityApi;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class AbstractAssemblerBlockEntity
extends BlockEntity {
    private final Direction facing;
    private volatile boolean assembling = false;
    protected final Set<BlockPos> blocks = new HashSet<BlockPos>();
    protected final DenseBlockPosSet checked = new DenseBlockPosSet();
    protected final Queue<BlockPos> queueing = new ArrayDeque<BlockPos>();
    private String shipSlug = null;

    protected AbstractAssemblerBlockEntity(BlockEntityType<? extends AbstractAssemblerBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
    }

    public boolean isAssembling() {
        return this.assembling;
    }

    protected void setAssembling(boolean assembling) {
        this.assembling = assembling;
    }

    public int getMaxAssembleDimension() {
        return 1024;
    }

    public int getMaxAssembleBlocks() {
        return 0x320000;
    }

    public int getBlockChecksPerTick() {
        return 65536;
    }

    public boolean startAssemble(String slug) {
        if (this.isAssembling()) {
            return false;
        }
        this.setAssembling(true);
        this.shipSlug = slug;
        this.blocks.clear();
        this.checked.clear();
        this.queueing.clear();
        BlockPos facingBlockPos = this.m_58899_().m_121945_(this.facing);
        this.checked.add(facingBlockPos.m_123341_(), facingBlockPos.m_123342_(), facingBlockPos.m_123343_());
        this.queueing.add(facingBlockPos);
        return true;
    }

    protected void finishAssemble() {
        this.setAssembling(false);
        this.shipSlug = null;
        this.blocks.clear();
        this.checked.clear();
        this.queueing.clear();
    }

    protected void finishAssembleAsSuccess() {
        this.finishAssemble();
    }

    protected void finishAssembleAsAssembleSelf() {
        this.finishAssemble();
    }

    protected void finishAssembleAsTooManyBlocks() {
        this.finishAssemble();
    }

    protected void finishAssembleAsNoBlockToAssemble() {
        this.finishAssemble();
    }

    protected void finishAssembleAsConflicts() {
        this.finishAssemble();
    }

    public void serverTick() {
        if (this.isAssembling()) {
            this.assembleTick((ServerLevel)this.m_58904_());
        }
    }

    private void assembleTick(ServerLevel level) {
        block7: {
            int maxAssembleBlocks = this.getMaxAssembleBlocks();
            int blockChecksPerTick = this.getBlockChecksPerTick();
            BlockPos selfPos = this.m_58899_();
            int ticked = 0;
            do {
                BlockPos pos;
                if ((pos = this.queueing.poll()) == null) {
                    this.checked.clear();
                    if (ticked > 0) {
                        return;
                    }
                    break block7;
                }
                if (this.blocks.size() > maxAssembleBlocks) {
                    this.finishAssembleAsTooManyBlocks();
                    return;
                }
                if (pos.equals((Object)selfPos)) {
                    this.finishAssembleAsAssembleSelf();
                    return;
                }
                this.addAssemblingBlock(pos);
                if (this.isAssembling()) continue;
                return;
            } while (++ticked <= blockChecksPerTick);
            return;
        }
        if (this.blocks.isEmpty()) {
            this.finishAssembleAsNoBlockToAssemble();
            return;
        }
        ServerShip ship = this.createShip(level, this.blocks);
        if (ship == null) {
            return;
        }
        this.onAssembleSuccess(ship);
    }

    protected void addAssemblingBlock(BlockPos pos) {
        if (BlockConnectivityApi.isAir(this.m_58904_().m_8055_(pos))) {
            return;
        }
        this.blocks.add(pos);
        for (BlockPos p : this.queryNextBlocks(pos)) {
            BlockState targetState = this.f_58857_.m_8055_(p);
            BlockEntity blockEntity = this.f_58857_.m_7702_(p);
            if (blockEntity instanceof AbstractAssemblerBlockEntity) {
                AbstractAssemblerBlockEntity otherAssembler = (AbstractAssemblerBlockEntity)blockEntity;
                if (this == otherAssembler) {
                    if (this.m_58899_().m_121945_(this.facing).equals((Object)pos)) continue;
                    this.finishAssembleAsAssembleSelf();
                    return;
                }
                if (!otherAssembler.isAssembling()) continue;
                this.finishAssembleAsConflicts();
                return;
            }
            if (!this.checked.add(p.m_123341_(), p.m_123342_(), p.m_123343_())) continue;
            this.queueing.add(p.m_7949_());
        }
    }

    protected Iterable<BlockPos> queryNextBlocks(BlockPos pos) {
        HashSet<BlockPos> result = new HashSet<BlockPos>(6);
        BlockConnectivityApi.getConnectableBlocks((LevelAccessor)this.m_58904_(), pos, result);
        return result;
    }

    protected ServerShip createShip(ServerLevel level, Set<BlockPos> blocks) {
        ServerShip ship = AssembleApi.createShip(level, blocks, VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)this.m_58899_()));
        if (ship == null) {
            this.finishAssembleAsNoBlockToAssemble();
            return null;
        }
        ship.setSlug(this.shipSlug);
        this.finishAssembleAsSuccess();
        return ship;
    }

    protected void onAssembleSuccess(ServerShip ship) {
    }
}

