/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.mixin.minecraft.position_based_conn;

import com.github.litermc.vtil.api.connectivity.IBlockAnchor;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChainBlock.class})
public abstract class MixinChainBlock
extends Block
implements IBlockAnchor {
    protected MixinChainBlock() {
        super(null);
    }

    @Override
    public void getConnectableBlocks(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> result) {
        switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
            case X: {
                result.add(pos.m_121945_(Direction.WEST));
                result.add(pos.m_121945_(Direction.EAST));
                break;
            }
            case Y: {
                result.add(pos.m_121945_(Direction.DOWN));
                result.add(pos.m_121945_(Direction.UP));
                break;
            }
            case Z: {
                result.add(pos.m_121945_(Direction.NORTH));
                result.add(pos.m_121945_(Direction.SOUTH));
            }
        }
    }

    @Override
    public boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        int xDiff = targetPos.m_123341_() - pos.m_123341_();
        int yDiff = targetPos.m_123342_() - pos.m_123342_();
        int zDiff = targetPos.m_123343_() - pos.m_123343_();
        if (Math.abs(xDiff) + Math.abs(yDiff) + Math.abs(zDiff) != 1) {
            return false;
        }
        Direction dir = Direction.m_122378_((int)xDiff, (int)yDiff, (int)zDiff);
        return dir.m_122434_() == state.m_61143_((Property)BlockStateProperties.f_61365_);
    }

    @Override
    public boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState state) {
        if (oldState == state) {
            return false;
        }
        if (oldState.m_60734_().getClass() != this.getClass()) {
            return true;
        }
        return oldState.m_61143_((Property)BlockStateProperties.f_61365_) != state.m_61143_((Property)BlockStateProperties.f_61365_);
    }
}

