/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.mixin.minecraft.position_based_conn;

import com.github.litermc.vtil.api.connectivity.BasicNeighbourBlockAnchor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={DoorBlock.class})
public abstract class MixinDoorBlock
extends Block
implements BasicNeighbourBlockAnchor {
    protected MixinDoorBlock() {
        super(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        int xDiff = targetPos.m_123341_() - pos.m_123341_();
        int yDiff = targetPos.m_123342_() - pos.m_123342_();
        int zDiff = targetPos.m_123343_() - pos.m_123343_();
        if (Math.abs(xDiff) + Math.abs(yDiff) + Math.abs(zDiff) != 1) {
            return false;
        }
        Direction dir = Direction.m_122378_((int)xDiff, (int)yDiff, (int)zDiff);
        Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
        switch (dir) {
            case UP: 
            case DOWN: {
                return true;
            }
            default: {
                if (facing == dir) return true;
                if ((switch ((DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_)) {
                    default -> throw new IncompatibleClassChangeError();
                    case DoorHingeSide.LEFT -> facing.m_122427_();
                    case DoorHingeSide.RIGHT -> facing.m_122428_();
                }) != dir) return false;
                return true;
            }
        }
    }

    @Override
    public boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState state) {
        if (oldState == state) {
            return false;
        }
        return oldState.m_60734_().getClass() != this.getClass();
    }
}

