/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.mixin.minecraft.position_based_conn;

import com.github.litermc.vtil.api.connectivity.IBlockAnchor;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={CampfireBlock.class, CarpetBlock.class})
public abstract class MixinOnlyNoCeilSupportedBlocks
extends Block
implements IBlockAnchor {
    protected MixinOnlyNoCeilSupportedBlocks() {
        super(null);
    }

    @Override
    public void getConnectableBlocks(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> result) {
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP) continue;
            result.add(pos.m_121945_(dir));
        }
    }

    @Override
    public boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        int xDiff = targetPos.m_123341_() - pos.m_123341_();
        int yDiff = targetPos.m_123342_() - pos.m_123342_();
        int zDiff = targetPos.m_123343_() - pos.m_123343_();
        if (Math.abs(xDiff) + Math.abs(yDiff) + Math.abs(zDiff) != 1) {
            return false;
        }
        Direction dir = Direction.m_122378_((int)xDiff, (int)yDiff, (int)zDiff);
        return dir != Direction.UP;
    }

    @Override
    public boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState state) {
        return oldState.m_60734_().getClass() != this.getClass();
    }
}

