/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.mixin.minecraft.position_based_conn;

import com.github.litermc.vtil.api.connectivity.IBlockAnchor;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={SlabBlock.class})
public abstract class MixinSlabBlock
extends Block
implements IBlockAnchor {
    protected MixinSlabBlock() {
        super(null);
    }

    @Override
    public void getConnectableBlocks(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> result) {
        switch ((SlabType)state.m_61143_((Property)SlabBlock.f_56353_)) {
            case TOP: {
                for (Direction dir : Direction.values()) {
                    if (dir == Direction.DOWN) continue;
                    result.add(pos.m_121945_(dir));
                }
                break;
            }
            case BOTTOM: {
                for (Direction dir : Direction.values()) {
                    if (dir == Direction.UP) continue;
                    result.add(pos.m_121945_(dir));
                }
                break;
            }
            case DOUBLE: {
                for (Direction dir : Direction.values()) {
                    result.add(pos.m_121945_(dir));
                }
                break;
            }
        }
    }

    @Override
    public boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        int xDiff = targetPos.m_123341_() - pos.m_123341_();
        int yDiff = targetPos.m_123342_() - pos.m_123342_();
        int zDiff = targetPos.m_123343_() - pos.m_123343_();
        if (Math.abs(xDiff) + Math.abs(yDiff) + Math.abs(zDiff) != 1) {
            return false;
        }
        Direction dir = Direction.m_122378_((int)xDiff, (int)yDiff, (int)zDiff);
        return switch ((SlabType)state.m_61143_((Property)SlabBlock.f_56353_)) {
            default -> throw new IncompatibleClassChangeError();
            case SlabType.TOP -> {
                if (dir != Direction.DOWN) {
                    yield true;
                }
                yield false;
            }
            case SlabType.BOTTOM -> {
                if (dir != Direction.UP) {
                    yield true;
                }
                yield false;
            }
            case SlabType.DOUBLE -> true;
        };
    }

    @Override
    public boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState state) {
        if (oldState == state) {
            return false;
        }
        if (oldState.m_60734_().getClass() != this.getClass()) {
            return true;
        }
        return oldState.m_61143_((Property)SlabBlock.f_56353_) != state.m_61143_((Property)SlabBlock.f_56353_);
    }
}

