/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.mixin.minecraft.position_based_conn;

import com.github.litermc.vtil.api.connectivity.BasicNeighbourBlockAnchor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={TrapDoorBlock.class})
public abstract class MixinTrapDoorBlock
extends Block
implements BasicNeighbourBlockAnchor {
    protected MixinTrapDoorBlock() {
        super(null);
    }

    @Override
    public boolean isBlockConnectable(LevelAccessor level, BlockPos pos, BlockState state, BlockPos targetPos, BlockState targetState) {
        int xDiff = targetPos.m_123341_() - pos.m_123341_();
        int yDiff = targetPos.m_123342_() - pos.m_123342_();
        int zDiff = targetPos.m_123343_() - pos.m_123343_();
        if (Math.abs(xDiff) + Math.abs(yDiff) + Math.abs(zDiff) != 1) {
            return false;
        }
        Direction dir = Direction.m_122378_((int)xDiff, (int)yDiff, (int)zDiff);
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        return switch (dir) {
            case Direction.UP -> {
                if (isOpen || state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP) {
                    yield true;
                }
                yield false;
            }
            case Direction.DOWN -> {
                if (isOpen || state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM) {
                    yield true;
                }
                yield false;
            }
            default -> !isOpen || state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != dir;
        };
    }

    @Override
    public boolean willConnectivityChange(LevelAccessor level, BlockPos pos, BlockState oldState, BlockState state) {
        return oldState != state;
    }
}

