/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.assemble;

import com.github.litermc.vtil.api.assemble.IMoveable;
import com.github.litermc.vtil.api.assemble.MoveApi;
import com.github.litermc.vtil.compat.CompatMods;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3829;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class AssembleApi {
    private AssembleApi() {
    }

    public static ServerShip createShip(class_3218 level, Set<class_2338> blocks, final ServerShip rootShip) {
        class_2338 targetPos;
        class_2680 state;
        class_2680 AIR = class_2246.field_10124.method_9564();
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((class_3218)level);
        String levelId = VSGameUtilsKt.getDimensionId((class_1937)level);
        AABBd blocksBox = new AABBd();
        class_2338 pos = blocks.iterator().next();
        blocksBox.setMin((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).setMax((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        for (class_2338 pos2 : blocks) {
            blocksBox.union((double)pos2.method_10263(), (double)pos2.method_10264(), (double)pos2.method_10260());
        }
        blocksBox.maxX += 1.0;
        blocksBox.maxY += 1.0;
        blocksBox.maxZ += 1.0;
        Vector3i worldCenter = new Vector3i((Vector3dc)blocksBox.center(new Vector3d()), 0);
        final ServerShip ship = shipWorld.createNewShipAtBlock((Vector3ic)worldCenter, false, 1.0, levelId);
        Vector3i shipCenter = ship.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((class_1937)level), new Vector3i());
        Vector3i offset = shipCenter.sub((Vector3ic)worldCenter, new Vector3i());
        HashMap<class_2338, class_2680> blockStates = new HashMap<class_2338, class_2680>(blocks.size());
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (class_1297 entity : level.method_8335(null, new class_238(blocksBox.minX - 1.0, blocksBox.minY - 1.0, blocksBox.minZ - 1.0, blocksBox.maxX + 2.0, blocksBox.maxY + 2.0, blocksBox.maxZ + 2.0))) {
            if (entity instanceof class_1530) {
                class_1530 he = (class_1530)entity;
                class_2338 hanging = he.method_6896().method_10093(he.method_5735().method_10153());
                if (!blocks.contains(hanging)) continue;
                entities.add(entity);
                continue;
            }
            if (!CompatMods.CREATE.isLoaded()) continue;
            if (entity instanceof SeatEntity) {
                SeatEntity seat = (SeatEntity)entity;
                if (!blocks.contains(seat.method_24515())) continue;
                entities.add(entity);
                continue;
            }
            if (!(entity instanceof SuperGlueEntity)) continue;
            SuperGlueEntity glue = (SuperGlueEntity)entity;
            class_238 bb = glue.method_5829();
            if (!AssembleApi.streamBlocksInAABB(bb).anyMatch(blocks::contains)) continue;
            entities.add(entity);
        }
        for (class_2338 pos3 : blocks) {
            class_2338 target = pos3.method_10069(offset.x, offset.y, offset.z);
            class_2680 oldState = level.method_8320(pos3);
            boolean wasAir = oldState.method_26215();
            class_2586 be = level.method_8321(pos3);
            IMoveable<?> moveableOld = MoveApi.getMover(be);
            if (moveableOld == null) {
                moveableOld = MoveApi.getMover(oldState.method_26204());
            }
            if (moveableOld != null) {
                moveableOld.beforeSaveForMove(level, pos3, target);
            }
            state = level.method_8320(pos3);
            if (wasAir && moveableOld == null && state == oldState) continue;
            blockStates.put(pos3.method_10062(), state);
            class_2487 nbt = level.method_8500(pos3).method_20598(pos3);
            if (nbt != null) {
                targetPos = pos3.method_10069(offset.x, offset.y, offset.z);
                nbt.method_10569("x", targetPos.method_10263());
                nbt.method_10569("y", targetPos.method_10264());
                nbt.method_10569("z", targetPos.method_10260());
                level.method_8500(targetPos).method_12042(nbt);
            }
            class_3829.method_16825((Object)be);
            Object moveData = moveableOld != null ? (Object)moveableOld.beforeMove(level, pos3, target) : null;
            level.method_8652(pos3, AIR, 82);
            level.method_8652(target, state, 82);
            class_2350[] moveableNew = MoveApi.getMover(level.method_8321(target));
            if (moveableNew == null) {
                moveableNew = MoveApi.getMover(state.method_26204());
            }
            if (moveableNew == null) continue;
            moveableNew.afterMove(level, pos3, target, moveData);
        }
        if (blockStates.isEmpty()) {
            shipWorld.deleteShip(ship);
            return null;
        }
        for (class_1297 entity : entities) {
            class_243 pos4 = entity.method_19538();
            entity.method_5814(pos4.field_1352 + (double)offset.x, pos4.field_1351 + (double)offset.y, pos4.field_1350 + (double)offset.z);
        }
        int MAX_BLOCK_UPDATE = 511;
        int BLOCK_UPDATE_FLAGS = 65;
        DenseBlockPosSet tickedAirs = new DenseBlockPosSet();
        class_2338.class_2339 airPos = new class_2338.class_2339();
        for (Map.Entry entry : blockStates.entrySet()) {
            class_2338 pos5 = (class_2338)entry.getKey();
            state = (class_2680)entry.getValue();
            class_2248 block = state.method_26204();
            targetPos = pos5.method_10069(offset.x, offset.y, offset.z);
            level.method_8408(pos5, block);
            state.method_26198((class_1936)level, pos5, 65, 511);
            AIR.method_26183((class_1936)level, pos5, 65, 511);
            level.method_19282(pos5, state, AIR);
            level.method_8408(targetPos, block);
            state.method_26183((class_1936)level, targetPos, 65, 511);
            state.method_26198((class_1936)level, targetPos, 65, 511);
            level.method_19282(targetPos, AIR, state);
            for (class_2350 dir : class_2350.values()) {
                airPos.method_25505((class_2382)targetPos, dir);
                if (blockStates.containsKey(airPos) || !tickedAirs.add(airPos.method_10263(), airPos.method_10264(), airPos.method_10260())) continue;
                AIR.method_26183((class_1936)level, (class_2338)airPos, 65, 511);
            }
        }
        final Vector3d absPosition = ship.getTransform().getPositionInWorld().add(ship.getInertiaData().getCenterOfMassInShip(), new Vector3d()).sub((double)shipCenter.x, (double)shipCenter.y, (double)shipCenter.z);
        final Vector3d position = new Vector3d((Vector3dc)absPosition);
        final Quaterniond rotation = new Quaterniond();
        final Vector3d velocity = new Vector3d();
        final Vector3d omega = new Vector3d();
        final Vector3d scaling = new Vector3d(1.0);
        double scale = 1.0;
        if (rootShip != null) {
            ShipTransform selfTransform = rootShip.getTransform();
            selfTransform.getShipToWorld().transformPosition(position);
            rotation.set(selfTransform.getShipToWorldRotation());
            velocity.set(rootShip.getVelocity());
            omega.set(rootShip.getOmega());
            scaling.set(selfTransform.getShipToWorldScaling());
            scale = Math.sqrt(scaling.lengthSquared() / 3.0);
        }
        shipWorld.teleportShip(ship, (ShipTeleportData)new ShipTeleportDataImpl((Vector3dc)position, (Quaterniondc)rotation, (Vector3dc)velocity, (Vector3dc)omega, levelId, Double.valueOf(scale)));
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            final ServerShipTransformProvider oldProvider = ship.getTransformProvider();
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform transform, ShipTransform nextTransform) {
                    if (!transform.getPositionInWorld().equals(nextTransform.getPositionInWorld()) || !transform.getShipToWorldRotation().equals(nextTransform.getShipToWorldRotation())) {
                        ship.setTransformProvider(oldProvider);
                        return null;
                    }
                    if (rootShip != null) {
                        ShipTransform selfTransform2 = rootShip.getTransform();
                        selfTransform2.getShipToWorld().transformPosition((Vector3dc)absPosition, position);
                        rotation.set(selfTransform2.getShipToWorldRotation());
                        velocity.set(rootShip.getVelocity());
                        omega.set(rootShip.getOmega());
                        scaling.set(selfTransform2.getShipToWorldScaling());
                    }
                    return new ServerShipTransformProvider.NextTransformAndVelocityData((ShipTransform)new ShipTransformImpl((Vector3dc)position, nextTransform.getPositionInShip(), (Quaterniondc)rotation, (Vector3dc)scaling), (Vector3dc)velocity, (Vector3dc)omega);
                }
            });
        }
        return ship;
    }

    private static Stream<class_2338> streamBlocksInAABB(class_238 box) {
        int minX = (int)Math.round(box.field_1323);
        int maxX = (int)Math.round(box.field_1320);
        int minY = (int)Math.round(box.field_1322);
        int maxY = (int)Math.round(box.field_1325);
        int minZ = (int)Math.round(box.field_1321);
        int maxZ = (int)Math.round(box.field_1324);
        int widthX = maxX - minX;
        int widthY = maxY - minY;
        int widthZ = maxZ - minZ;
        return IntStream.range(0, widthX * widthY * widthZ).mapToObj(i -> {
            int x = i % widthX + minX;
            int z = (i /= widthX) % widthZ + minZ;
            int y = (i /= widthZ) + minY;
            return new class_2338(x, y, z);
        });
    }
}

