/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.connectivity;

import com.github.litermc.vtil.api.connectivity.IBlockAnchor;
import java.util.Collection;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3610;

public final class BlockConnectivityApi {
    private BlockConnectivityApi() {
    }

    public static final boolean isAir(class_2680 state) {
        class_3610 fluidState;
        if (state.method_26215()) {
            return true;
        }
        return state.method_26204() instanceof class_2404 && ((fluidState = state.method_26227()).method_15769() || !fluidState.method_15771());
    }

    public static final boolean isFluidLogged(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12508) && (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false;
    }

    public static final void getPossibleConnectableBlocks(class_1936 level, class_2338 pos, class_2680 state, Collection<class_2338> result) {
        if (BlockConnectivityApi.isFluidLogged(state)) {
            for (class_2350 dir : class_2350.values()) {
                result.add(pos.method_10093(dir));
            }
            return;
        }
        IBlockAnchor anchor = (IBlockAnchor)state.method_26204();
        anchor.getConnectableBlocks(level, pos, state, result);
    }

    public static final void getConnectableBlocks(class_1936 level, class_2338 pos, Collection<class_2338> result) {
        class_2680 state = level.method_8320(pos);
        if (BlockConnectivityApi.isAir(state)) {
            return;
        }
        BlockConnectivityApi.getConnectableBlocks(level, pos, state, result);
    }

    public static final void getConnectableBlocks(class_1936 level, class_2338 pos, class_2680 state, Collection<class_2338> result) {
        BlockConnectivityApi.getPossibleConnectableBlocks(level, pos, state, result);
        result.removeIf(p -> {
            class_2680 s = level.method_8320(p);
            return BlockConnectivityApi.isAir(s) || !BlockConnectivityApi.isBlockConnectable0(level, p, s, pos, state);
        });
    }

    public static final boolean isBlockConnectable(class_1936 level, class_2338 pos, class_2338 targetPos) {
        class_2680 state = level.method_8320(pos);
        if (BlockConnectivityApi.isAir(state)) {
            return false;
        }
        class_2680 targetState = level.method_8320(targetPos);
        if (BlockConnectivityApi.isAir(targetState)) {
            return false;
        }
        return BlockConnectivityApi.isBlockConnectable(level, pos, state, targetPos, targetState);
    }

    public static final boolean isBlockConnectable(class_1936 level, class_2338 pos, class_2680 state, class_2338 targetPos, class_2680 targetState) {
        return BlockConnectivityApi.isBlockConnectable0(level, pos, state, targetPos, targetState) && BlockConnectivityApi.isBlockConnectable0(level, targetPos, targetState, pos, state);
    }

    private static final boolean isBlockConnectable0(class_1936 level, class_2338 pos, class_2680 state, class_2338 targetPos, class_2680 targetState) {
        return BlockConnectivityApi.isFluidLogged(state) || ((IBlockAnchor)state.method_26204()).isBlockConnectable(level, pos, state, targetPos, targetState);
    }

    public static boolean willConnectivityChange(class_1936 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (oldState == newState) {
            return false;
        }
        if (BlockConnectivityApi.isFluidLogged(oldState) && BlockConnectivityApi.isFluidLogged(newState)) {
            return false;
        }
        boolean wasAir = BlockConnectivityApi.isAir(oldState);
        if (wasAir != BlockConnectivityApi.isAir(newState)) {
            return true;
        }
        if (wasAir) {
            return false;
        }
        IBlockAnchor anchor = (IBlockAnchor)newState.method_26204();
        return anchor.willConnectivityChange(level, pos, oldState, newState);
    }
}

