/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.api.teleport;

import com.github.litermc.vtil.api.entity.ISpecialTeleportLogicEntity;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class TeleportUtil {
    public static void teleportShip(LoadedServerShip ship, TeleportData data) {
        class_3218 level = data.level();
        String dimension = VSGameUtilsKt.getDimensionId((class_1937)level);
        final ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((class_3218)level);
        final long id = ship.getId();
        Vector3dc newPos = data.newPos();
        Quaterniondc rotation = data.rotation();
        final Vector3dc velocity = data.velocity();
        final Vector3dc omega = data.omega();
        ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl(newPos, rotation, velocity, omega, dimension, null);
        world.teleportShip((ServerShip)ship, (ShipTeleportData)teleportData);
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            final ServerShipTransformProvider oldProvider = ship.getTransformProvider();
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform prevTransform, ShipTransform transform) {
                    LoadedServerShip ship2 = (LoadedServerShip)world.getLoadedShips().getById(id);
                    if (!prevTransform.getPositionInWorld().equals(transform.getPositionInWorld()) || !prevTransform.getShipToWorldRotation().equals(transform.getShipToWorldRotation())) {
                        ship2.setTransformProvider(oldProvider);
                        return null;
                    }
                    if (ship2.getVelocity().lengthSquared() == 0.0 && ship2.getOmega().lengthSquared() == 0.0) {
                        return new ServerShipTransformProvider.NextTransformAndVelocityData(transform, velocity, omega);
                    }
                    return null;
                }
            });
        }
    }

    public static <T extends class_1297> T teleportEntity(T entity, class_3218 newLevel, class_243 newPos) {
        Object newEntity;
        ISpecialTeleportLogicEntity specialEntity;
        class_243 oldPos = entity.method_19538();
        List<class_1297> passengers = List.copyOf(entity.method_5685());
        if (entity instanceof ISpecialTeleportLogicEntity) {
            ISpecialTeleportLogicEntity specialEntity2 = (ISpecialTeleportLogicEntity)entity;
            specialEntity2.beforeDimentionalTeleport();
        }
        for (class_1297 p : passengers) {
            if (!(p instanceof ISpecialTeleportLogicEntity)) continue;
            specialEntity = (ISpecialTeleportLogicEntity)p;
            specialEntity.beforeDimentionalTeleport();
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.method_14251(newLevel, newPos.field_1352, newPos.field_1351, newPos.field_1350, player.method_36454(), player.method_36455());
            newEntity = entity;
        } else {
            newEntity = entity.method_5864().method_5883((class_1937)newLevel);
            if (newEntity == null) {
                if (entity instanceof ISpecialTeleportLogicEntity) {
                    specialEntity = (ISpecialTeleportLogicEntity)entity;
                    specialEntity.afterDimentionalTeleport(null);
                }
                return null;
            }
            entity.method_5772();
            newEntity.method_5878(entity);
            newEntity.method_5808(newPos.field_1352, newPos.field_1351, newPos.field_1350, newEntity.method_36454(), newEntity.method_36455());
            newEntity.method_5847(entity.method_5791());
            newEntity.method_5636(entity.method_43078());
            newLevel.method_18769(newEntity);
            entity.method_31745(class_1297.class_5529.field_27002);
        }
        for (class_1297 p : passengers) {
            class_1297 newPassenger = TeleportUtil.teleportEntity(p, newLevel, p.method_19538().method_1020(oldPos).method_1019(newPos));
            if (newPassenger == null) continue;
            newPassenger.method_5873(newEntity, true);
        }
        if (newEntity instanceof ISpecialTeleportLogicEntity) {
            ISpecialTeleportLogicEntity specialEntity3 = (ISpecialTeleportLogicEntity)newEntity;
            specialEntity3.afterDimentionalTeleport((ISpecialTeleportLogicEntity)entity);
        }
        return (T)newEntity;
    }

    public record TeleportData(class_3218 level, Vector3dc newPos, Quaterniondc rotation, Vector3dc velocity, Vector3dc omega) {
    }
}

