/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.block;

import com.github.litermc.vtil.api.assemble.AssembleApi;
import com.github.litermc.vtil.api.connectivity.BlockConnectivityApi;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class AbstractAssemblerBlockEntity
extends class_2586 {
    private final class_2350 facing;
    private volatile boolean assembling = false;
    protected final Set<class_2338> blocks = new HashSet<class_2338>();
    protected final DenseBlockPosSet checked = new DenseBlockPosSet();
    protected final Queue<class_2338> queueing = new ArrayDeque<class_2338>();
    private String shipSlug = null;

    protected AbstractAssemblerBlockEntity(class_2591<? extends AbstractAssemblerBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.facing = (class_2350)this.method_11010().method_11654((class_2769)class_2318.field_10927);
    }

    public boolean isAssembling() {
        return this.assembling;
    }

    protected void setAssembling(boolean assembling) {
        this.assembling = assembling;
    }

    public int getMaxAssembleDimension() {
        return 1024;
    }

    public int getMaxAssembleBlocks() {
        return 0x320000;
    }

    public int getBlockChecksPerTick() {
        return 65536;
    }

    public boolean startAssemble(String slug) {
        if (this.isAssembling()) {
            return false;
        }
        this.setAssembling(true);
        this.shipSlug = slug;
        this.blocks.clear();
        this.checked.clear();
        this.queueing.clear();
        class_2338 facingBlockPos = this.method_11016().method_10093(this.facing);
        this.checked.add(facingBlockPos.method_10263(), facingBlockPos.method_10264(), facingBlockPos.method_10260());
        this.queueing.add(facingBlockPos);
        return true;
    }

    protected void finishAssemble() {
        this.setAssembling(false);
        this.shipSlug = null;
        this.blocks.clear();
        this.checked.clear();
        this.queueing.clear();
    }

    protected void finishAssembleAsSuccess() {
        this.finishAssemble();
    }

    protected void finishAssembleAsAssembleSelf() {
        this.finishAssemble();
    }

    protected void finishAssembleAsTooManyBlocks() {
        this.finishAssemble();
    }

    protected void finishAssembleAsNoBlockToAssemble() {
        this.finishAssemble();
    }

    protected void finishAssembleAsConflicts() {
        this.finishAssemble();
    }

    public void serverTick() {
        if (this.isAssembling()) {
            this.assembleTick((class_3218)this.method_10997());
        }
    }

    private void assembleTick(class_3218 level) {
        block7: {
            int maxAssembleBlocks = this.getMaxAssembleBlocks();
            int blockChecksPerTick = this.getBlockChecksPerTick();
            class_2338 selfPos = this.method_11016();
            int ticked = 0;
            do {
                class_2338 pos;
                if ((pos = this.queueing.poll()) == null) {
                    this.checked.clear();
                    if (ticked > 0) {
                        return;
                    }
                    break block7;
                }
                if (this.blocks.size() > maxAssembleBlocks) {
                    this.finishAssembleAsTooManyBlocks();
                    return;
                }
                if (pos.equals((Object)selfPos)) {
                    this.finishAssembleAsAssembleSelf();
                    return;
                }
                this.addAssemblingBlock(pos);
                if (this.isAssembling()) continue;
                return;
            } while (++ticked <= blockChecksPerTick);
            return;
        }
        if (this.blocks.isEmpty()) {
            this.finishAssembleAsNoBlockToAssemble();
            return;
        }
        ServerShip ship = this.createShip(level, this.blocks);
        if (ship == null) {
            return;
        }
        this.onAssembleSuccess(ship);
    }

    protected void addAssemblingBlock(class_2338 pos) {
        if (BlockConnectivityApi.isAir(this.method_10997().method_8320(pos))) {
            return;
        }
        this.blocks.add(pos);
        for (class_2338 p : this.queryNextBlocks(pos)) {
            class_2680 targetState = this.field_11863.method_8320(p);
            class_2586 class_25862 = this.field_11863.method_8321(p);
            if (class_25862 instanceof AbstractAssemblerBlockEntity) {
                AbstractAssemblerBlockEntity otherAssembler = (AbstractAssemblerBlockEntity)class_25862;
                if (this == otherAssembler) {
                    if (this.method_11016().method_10093(this.facing).equals((Object)pos)) continue;
                    this.finishAssembleAsAssembleSelf();
                    return;
                }
                if (!otherAssembler.isAssembling()) continue;
                this.finishAssembleAsConflicts();
                return;
            }
            if (!this.checked.add(p.method_10263(), p.method_10264(), p.method_10260())) continue;
            this.queueing.add(p.method_10062());
        }
    }

    protected Iterable<class_2338> queryNextBlocks(class_2338 pos) {
        HashSet<class_2338> result = new HashSet<class_2338>(6);
        BlockConnectivityApi.getConnectableBlocks((class_1936)this.method_10997(), pos, result);
        return result;
    }

    protected ServerShip createShip(class_3218 level, Set<class_2338> blocks) {
        ServerShip ship = AssembleApi.createShip(level, blocks, VSGameUtilsKt.getShipManagingPos((class_3218)level, (class_2338)this.method_11016()));
        if (ship == null) {
            this.finishAssembleAsNoBlockToAssemble();
            return null;
        }
        ship.setSlug(this.shipSlug);
        this.finishAssembleAsSuccess();
        return ship;
    }

    protected void onAssembleSuccess(ServerShip ship) {
    }
}

