/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vtil.platform;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.github.litermc.vtil.config.ConfigFile;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricConfigFile
extends ConfigFile {
    private static final Logger LOG = LoggerFactory.getLogger(FabricConfigFile.class);
    private final ConfigSpec spec;
    private final ConfigFile.ConfigListener onChange;
    private CommentedFileConfig config;

    private FabricConfigFile(ConfigSpec spec, Map<String, ConfigFile.Entry> entries, ConfigFile.ConfigListener onChange) {
        super(entries);
        this.spec = spec;
        this.onChange = onChange;
    }

    public synchronized void load(Path path) {
        this.closeConfig();
        CommentedFileConfig config = this.config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().onFileNotFound(FileNotFoundAction.READ_NOTHING).writingMode(WritingMode.REPLACE).build();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            FileWatcher.defaultInstance().addWatch(config.getNioPath(), this::loadConfig);
        }
        catch (IOException e) {
            LOG.error("Failed to load config from {}.", (Object)path, (Object)e);
        }
        if (this.loadConfig()) {
            config.save();
        }
    }

    private Stream<ValueImpl<?>> values() {
        return this.entries().filter(ValueImpl.class::isInstance);
    }

    public synchronized void unload() {
        this.closeConfig();
        this.values().forEach(ValueImpl::unload);
    }

    @GuardedBy(value="this")
    private void closeConfig() {
        if (this.config == null) {
            return;
        }
        this.config.close();
        FileWatcher.defaultInstance().removeWatch(this.config.getNioPath());
        this.config = null;
    }

    private synchronized boolean loadConfig() {
        CommentedFileConfig config = this.config;
        if (config == null) {
            return false;
        }
        LOG.info("Loading config from {}", (Object)config.getNioPath());
        config.load();
        boolean isNewFile = config.isEmpty();
        this.entries().forEach(x -> {
            String string;
            String string2 = x.path();
            if (x instanceof ValueImpl) {
                ValueImpl v = (ValueImpl)x;
                string = v.fullComment;
            } else {
                string = x.comment();
            }
            config.setComment(string2, string);
        });
        int corrected = isNewFile ? this.spec.correct((Config)config) : this.spec.correct((Config)config, (action, entryPath, oldValue, newValue) -> LOG.warn("Incorrect key {} was corrected from {} to {}", new Object[]{String.join((CharSequence)".", entryPath), oldValue, newValue}));
        this.values().forEach(x -> x.load((Config)config));
        this.onChange.onConfigChanged(config.getNioPath());
        return corrected > 0;
    }

    private static final class ValueImpl<T>
    extends ConfigFile.Value<T> {
        private T value;
        private final T defaultValue;
        private final TriFunction<Config, String, T, T> get;
        private final String fullComment;

        private ValueImpl(String path, String comment, String fullComment, T defaultValue, TriFunction<Config, String, T, T> get) {
            super(path, comment);
            this.fullComment = fullComment;
            this.defaultValue = defaultValue;
            this.get = get;
        }

        void unload() {
            this.value = null;
        }

        void load(Config config) {
            this.value = this.get.apply((Object)config, (Object)this.path, this.defaultValue);
        }

        @Override
        public T get() {
            T value = this.value;
            if (value == null) {
                throw new IllegalStateException("Config value " + this.path + " is not available");
            }
            return value;
        }
    }

    static class Builder
    extends ConfigFile.Builder {
        private final ConfigSpec spec = new ConfigSpec();

        Builder() {
        }

        @Override
        public ConfigFile.Builder worldRestart() {
            return this;
        }

        private <T> ConfigFile.Value<T> defineValue(String name, String comment, String suffix, T defaultValue, TriFunction<Config, String, T, T> getter) {
            String fullComment = suffix == null ? comment : comment + "\n" + suffix;
            ValueImpl<T> value = new ValueImpl<T>(this.getPath(name), comment, fullComment, defaultValue, getter);
            ((ConfigFile.Builder.RootGroup)this.groupStack.getLast()).children().put(name, value);
            return value;
        }

        @Override
        public <T> ConfigFile.Value<T> define(String name, T defaultValue) {
            String path = this.getPath(name);
            this.spec.define(path, defaultValue);
            return this.defineValue(name, this.takeComment(), null, defaultValue, UnmodifiableConfig::getOrElse);
        }

        @Override
        public ConfigFile.Value<Boolean> define(String name, boolean defaultValue) {
            String path = this.getPath(name);
            this.spec.define(path, (Object)defaultValue, x -> x instanceof Boolean);
            return this.defineValue(name, this.takeComment(), null, defaultValue, UnmodifiableConfig::getOrElse);
        }

        @Override
        public ConfigFile.Value<Integer> defineInRange(String name, int defaultValue, int min, int max) {
            String path = this.getPath(name);
            this.spec.defineInRange(path, (Comparable)Integer.valueOf(defaultValue), (Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max));
            String suffix = max == Integer.MAX_VALUE ? "Range: > " + min : "Range: " + min + " ~ " + max;
            return this.defineValue(name, this.takeComment(), suffix, defaultValue, UnmodifiableConfig::getIntOrElse);
        }

        @Override
        public <T> ConfigFile.Value<List<? extends T>> defineList(String name, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            String path = this.getPath(name);
            this.spec.defineList(path, defaultValue, elementValidator);
            return this.defineValue(name, this.takeComment(), null, defaultValue, UnmodifiableConfig::getOrElse);
        }

        @Override
        public <V extends Enum<V>> ConfigFile.Value<V> defineEnum(String name, V defaultValue) {
            String path = this.getPath(name);
            this.spec.define(path, defaultValue, o -> o != null && o != NullObject.NULL_OBJECT && EnumGetMethod.NAME_IGNORECASE.validate(o, defaultValue.getDeclaringClass()));
            String suffix = "Allowed Values: " + Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
            return this.defineValue(name, this.takeComment(), suffix, defaultValue, (c, p, d) -> c.getEnumOrElse(p, d, EnumGetMethod.NAME_IGNORECASE));
        }

        @Override
        public ConfigFile build(ConfigFile.ConfigListener onChange) {
            Map<String, ConfigFile.Entry> children = ((ConfigFile.Builder.RootGroup)this.groupStack.removeLast()).children();
            if (!this.groupStack.isEmpty()) {
                throw new IllegalStateException("Mismatched config push/pop");
            }
            return new FabricConfigFile(this.spec, children, onChange);
        }
    }
}

