/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.duration;

import de.jvstvshd.necrify.api.duration.PermanentPunishmentDuration;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.duration.RelativePunishmentDuration;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;

public class AbsolutePunishmentDuration
implements PunishmentDuration {
    public static final LocalDateTime MAX = LocalDateTime.of(9999, 12, 31, 23, 59, 59);
    public static final Timestamp MAX_TIMESTAMP = Timestamp.valueOf(MAX);
    private final LocalDateTime expiration;

    AbsolutePunishmentDuration(LocalDateTime expiration) {
        this.expiration = expiration;
    }

    public static PunishmentDuration from(LocalDateTime ldt) {
        if (!ldt.isBefore(MAX)) {
            return PermanentPunishmentDuration.PERMANENT;
        }
        return new AbsolutePunishmentDuration(ldt);
    }

    @Override
    public boolean isPermanent() {
        return !this.expiration.isBefore(MAX);
    }

    @Override
    public AbsolutePunishmentDuration absolute() {
        return this;
    }

    @Override
    public RelativePunishmentDuration relative() {
        return new RelativePunishmentDuration(Duration.between(LocalDateTime.now(), this.expiration));
    }

    @Override
    public LocalDateTime expiration() {
        return this.expiration;
    }

    @Override
    public Timestamp expirationAsTimestamp() {
        return Timestamp.valueOf(this.expiration);
    }

    @Override
    public String expirationAsString() {
        return this.expiration().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
    }

    @Override
    public String remainingDuration(PunishmentDuration.StringRepresentation mode) {
        return this.relative().remainingDuration(mode);
    }

    @Override
    public int compareTo(@NotNull PunishmentDuration other) {
        return this.expiration.compareTo(other.expiration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbsolutePunishmentDuration that = (AbsolutePunishmentDuration)o;
        return this.expiration.equals(that.expiration);
    }

    public int hashCode() {
        return this.expiration.hashCode();
    }

    public String toString() {
        return "AbsolutePunishmentDuration{expiration=" + String.valueOf(this.expiration) + "}";
    }
}

