/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.duration;

import de.jvstvshd.necrify.api.duration.AbsolutePunishmentDuration;
import de.jvstvshd.necrify.api.duration.PermanentPunishmentDuration;
import de.jvstvshd.necrify.api.duration.RelativePunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.TemporalPunishment;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;

public interface PunishmentDuration
extends Comparable<PunishmentDuration> {
    public static final PunishmentDuration PERMANENT = PermanentPunishmentDuration.PERMANENT;

    public static PunishmentDuration parse(String source) {
        return new Parser(source).parse();
    }

    @Deprecated(forRemoval=true, since="1.2.2")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static PunishmentDuration permanent() {
        return PERMANENT;
    }

    public static PunishmentDuration from(LocalDateTime ldt) {
        return AbsolutePunishmentDuration.from(ldt);
    }

    public static PunishmentDuration fromTimestamp(Timestamp timestamp) {
        return PunishmentDuration.from(timestamp.toLocalDateTime());
    }

    public static PunishmentDuration fromMillis(long millis) {
        return PunishmentDuration.fromDuration(Duration.ofMillis(millis));
    }

    public static PunishmentDuration fromDuration(Duration duration) {
        RelativePunishmentDuration rpd = new RelativePunishmentDuration(duration);
        if (rpd.isPermanent()) {
            return PermanentPunishmentDuration.PERMANENT;
        }
        return rpd;
    }

    public static PunishmentDuration ofPunishment(Punishment punishment) {
        if (punishment instanceof TemporalPunishment) {
            TemporalPunishment temporalPunishment = (TemporalPunishment)punishment;
            return temporalPunishment.getDuration();
        }
        return PermanentPunishmentDuration.PERMANENT;
    }

    public boolean isPermanent();

    public AbsolutePunishmentDuration absolute();

    public RelativePunishmentDuration relative();

    public LocalDateTime expiration();

    public Timestamp expirationAsTimestamp();

    public String expirationAsString();

    default public String remainingDuration() {
        return this.remainingDuration(StringRepresentation.LONG);
    }

    public String remainingDuration(StringRepresentation var1);

    default public PunishmentDuration initialDuration() {
        throw new UnsupportedOperationException("Initial durations are not stored.");
    }

    default public Duration javaDuration() {
        return Duration.between(LocalDateTime.now(), this.expiration());
    }

    public static class Parser {
        private static final Map<Character, TimeUnit> characterMapping = new HashMap<Character, TimeUnit>(){
            {
                this.put(Character.valueOf('s'), TimeUnit.SECONDS);
                this.put(Character.valueOf('m'), TimeUnit.MINUTES);
                this.put(Character.valueOf('h'), TimeUnit.HOURS);
                this.put(Character.valueOf('d'), TimeUnit.DAYS);
            }
        };
        private final String source;
        private final Map<TimeUnit, Long> rawDuration;

        public Parser(String source) {
            this.source = source;
            this.rawDuration = new HashMap<TimeUnit, Long>();
        }

        public void convert() {
            String[] numbers = this.source.split("[sSmMhHdD]");
            HashMap<TimeUnit, Long> converted = new HashMap<TimeUnit, Long>();
            int index = 0;
            for (String number : numbers) {
                char unit;
                long numericValue;
                index += number.length();
                try {
                    numericValue = Long.parseLong(number);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Not a number: " + e.getMessage());
                }
                if (numericValue < 0L) {
                    throw new ParseException("Illegal numeric value: " + numericValue);
                }
                try {
                    unit = Character.toLowerCase(this.source.charAt(index));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ParseException("Number is not followed by unit marking character.");
                }
                TimeUnit timeUnit = characterMapping.get(Character.valueOf(unit));
                if (timeUnit == null) {
                    throw new ParseException("Unknown time unit for character '" + unit + "'");
                }
                converted.put(timeUnit, numericValue);
                ++index;
            }
            this.rawDuration.clear();
            this.rawDuration.putAll(converted);
        }

        public PunishmentDuration parse() {
            if (this.source.isEmpty()) {
                throw new ParseException("Source string is empty.");
            }
            this.convert();
            if (this.rawDuration.isEmpty()) {
                throw new ParseException("Converted map is empty.");
            }
            return PunishmentDuration.fromMillis(this.durationToMillis());
        }

        private long convertToMillis(TimeUnit unit, long value) {
            return unit.toMillis(value);
        }

        private long durationToMillis() {
            long total = 0L;
            for (Map.Entry<TimeUnit, Long> entry : this.rawDuration.entrySet()) {
                total += this.convertToMillis(entry.getKey(), entry.getValue());
            }
            return total;
        }

        public static class ParseException
        extends RuntimeException {
            public ParseException(String message) {
                super(message);
            }
        }
    }

    public static enum StringRepresentation {
        FULL,
        SHORT,
        LONG;

    }
}

