/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.duration;

import de.jvstvshd.necrify.api.duration.AbsolutePunishmentDuration;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class RelativePunishmentDuration
implements PunishmentDuration {
    private final Duration duration;

    RelativePunishmentDuration(Duration duration) {
        this.duration = duration;
    }

    public static PunishmentDuration zero() {
        return new RelativePunishmentDuration(Duration.ofMillis(0L));
    }

    @Override
    public boolean isPermanent() {
        return !this.expiration().isBefore(LocalDateTime.MAX);
    }

    @Override
    public AbsolutePunishmentDuration absolute() {
        return new AbsolutePunishmentDuration(this.expiration());
    }

    @Override
    public RelativePunishmentDuration relative() {
        return this;
    }

    @Override
    public LocalDateTime expiration() {
        return LocalDateTime.now().plus(this.duration);
    }

    @Override
    public Timestamp expirationAsTimestamp() {
        return Timestamp.valueOf(this.expiration());
    }

    @Override
    public String expirationAsString() {
        return this.absolute().expirationAsString();
    }

    @Override
    public String remainingDuration(PunishmentDuration.StringRepresentation mode) {
        return this.representDuration(Duration.between(LocalDateTime.now(), this.expiration()), mode);
    }

    public String toString() {
        return "PunishmentDuration{duration=" + String.valueOf(this.duration) + ", expiration=" + String.valueOf(this.expiration()) + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RelativePunishmentDuration that = (RelativePunishmentDuration)obj;
        return Objects.equals(this.duration, that.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    @Override
    public int compareTo(@NotNull PunishmentDuration other) {
        return this.duration.compareTo(other.relative().javaDuration());
    }

    private String representDuration(Duration duration, PunishmentDuration.StringRepresentation mode) {
        List<String> values = Stream.concat(Stream.of(String.valueOf(duration.toDaysPart())), Stream.of(duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart()).map(this::normalizeTimeUnit)).toList();
        List<Character> units = Arrays.asList(Character.valueOf('d'), Character.valueOf('h'), Character.valueOf('m'), Character.valueOf('s'));
        Set l = IntStream.range(0, values.size()).boxed().collect(Collectors.toMap(units::get, values::get, (s, s2) -> s + s2, LinkedHashMap::new)).entrySet();
        Stream valuesMapped = l.stream();
        Stream stream = switch (mode) {
            default -> throw new MatchException(null, null);
            case PunishmentDuration.StringRepresentation.FULL -> valuesMapped;
            case PunishmentDuration.StringRepresentation.SHORT -> valuesMapped.filter(entry -> !this.zeroDuration((String)entry.getValue()));
            case PunishmentDuration.StringRepresentation.LONG -> {
                int skip = 0;
                for (int i = 0; i < values.size() && skip == i; ++i) {
                    if (!this.zeroDuration(values.get(i))) continue;
                    ++skip;
                }
                yield valuesMapped.skip(skip);
            }
        };
        return stream.map(entry -> (String)entry.getValue() + String.valueOf(entry.getKey())).collect(Collectors.joining(""));
    }

    private boolean zeroDuration(String duration) {
        return duration.chars().allMatch(value -> value == 48);
    }

    private String normalizeTimeUnit(long value) {
        String s = String.valueOf(value);
        if (value == 0L) {
            return "00";
        }
        if (s.length() < 2) {
            return "0" + s;
        }
        return s;
    }
}

