/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.event;

import de.jvstvshd.necrify.api.event.NecrifyEvent;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Logger;
import org.jetbrains.annotations.NotNull;

public class EventDispatcher {
    private final EventBus eventbus;
    private final ExecutorService executorService;

    public EventDispatcher(@NotNull EventBus eventbus, ExecutorService executorService) {
        this.eventbus = eventbus;
        this.executorService = executorService;
    }

    public EventDispatcher(ExecutorService executorService, Logger logger) {
        this.executorService = executorService;
        this.eventbus = EventBus.builder().logNoSubscriberMessages(false).sendNoSubscriberEvent(false).logger(logger).executorService(executorService).build();
    }

    public void dispatch(NecrifyEvent event) {
        this.eventbus.post((Object)event.setExecutingDispatcher(this));
    }

    public CompletableFuture<Void> dispatchAsync(NecrifyEvent event) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executorService.execute(() -> {
            this.dispatch(event);
            future.complete(null);
        });
        return future;
    }

    public void register(@NotNull Object listener) {
        this.eventbus.register(Objects.requireNonNull(listener, "listener must not be null in order to get registered"));
    }

    public void unregister(@NotNull Object listener) {
        this.eventbus.unregister(Objects.requireNonNull(listener, "listener must not be null in order to get unregistered"));
    }

    public void cancelEvent(@NotNull NecrifyEvent event) {
        this.eventbus.cancelEventDelivery((Object)Objects.requireNonNull(event, "event must not be null in order to get cancelled"));
    }
}

