/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.message;

import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MessageProvider {
    @NotNull
    default public Component provide(@NotNull String key, @Nullable Locale locale, Component ... args) {
        return this.provide(key, locale, this.autoPrefixed(), args);
    }

    @NotNull
    default public Component provide(@NotNull String key, Component ... args) {
        return this.provide(key, this.autoPrefixed(), args);
    }

    @NotNull
    public Component provide(@NotNull String var1, @Nullable Locale var2, boolean var3, Component ... var4);

    @NotNull
    public Component provide(@NotNull String var1, boolean var2, Component ... var3);

    @NotNull
    default public Component internalError(@Nullable Locale locale) {
        return this.internalError(locale, this.autoPrefixed());
    }

    @NotNull
    default public Component internalError() {
        return this.internalError(this.autoPrefixed());
    }

    @NotNull
    public Component prefix();

    @NotNull
    public Component internalError(@Nullable Locale var1, boolean var2);

    @NotNull
    public Component internalError(boolean var1);

    @NotNull
    default public String provideString(@NotNull String key, @Nullable Locale locale, boolean prefixed, Component ... args) {
        return PlainTextComponentSerializer.plainText().serialize(this.provide(key, locale, prefixed, args));
    }

    @NotNull
    default public String provideString(@NotNull String key, @Nullable Locale locale, Component ... args) {
        return this.provideString(key, locale, this.autoPrefixed(), args);
    }

    @NotNull
    default public Component prefixed(Component ... args) {
        Component comp = this.prefix();
        for (Component arg : args) {
            comp = comp.append(arg);
        }
        return comp;
    }

    @NotNull
    default public Locale defaultLocale() {
        return Locale.ENGLISH;
    }

    public boolean autoPrefixed();

    public MessageProvider autoPrefixed(boolean var1);

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    default public MessageProvider unprefixedProvider() {
        throw new UnsupportedOperationException("This message provider does not support changing the auto-prefixing behavior.");
    }
}

