/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.punishment;

import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLog;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogEntry;
import de.jvstvshd.necrify.api.punishment.util.ReasonHolder;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Punishment
extends ReasonHolder {
    public boolean isOngoing();

    public CompletableFuture<Punishment> punish();

    public CompletableFuture<Punishment> cancel();

    public CompletableFuture<Punishment> change(@Nullable Component var1);

    @NotNull
    public PunishmentType getType();

    @NotNull
    public UUID getPunishmentUuid();

    @NotNull
    public UUID getUuid();

    @NotNull
    public NecrifyUser getUser();

    public boolean hasSuccessor();

    @NotNull
    public Punishment getSuccessor();

    @Nullable
    default public Punishment getSuccessorOrNull() {
        if (this.hasSuccessor()) {
            return this.getSuccessor();
        }
        return null;
    }

    @NotNull
    public CompletableFuture<Punishment> setSuccessor(Punishment var1);

    @NotNull
    public LocalDateTime getCreationTime();

    public boolean hasBeenCreated();

    @Nullable
    public Punishment getPredecessor();

    @NotNull
    public CompletableFuture<PunishmentLog> loadPunishmentLog();

    @NotNull
    public PunishmentLogEntry createCurrentLogEntry();

    @NotNull
    public Optional<NecrifyTemplateStage> getTemplateStage();
}

